/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import gnu.trove.THashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.CustomExceptionHandler;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceListElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.AnalysisCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            @Override
            public void visitElement(PsiElement psiElement) {
                PsiElement parent2;
                if (psiElement != element && (parent2 = psiElement.getParent()) instanceof PsiAnonymousClass && !(psiElement instanceof PsiExpressionList)) {
                    return;
                }
                super.visitElement(psiElement);
            }

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass2) {
                this.visitElement(aClass2);
            }

            @Override
            public void visitClass(PsiClass aClass2) {
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef = expression2.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            @Override
            public void visitThrowStatement(PsiThrowStatement statement2) {
                PsiExpression expr = statement2.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result2, StreamEx.of(ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement2);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            @Override
            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result2, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            @Override
            public void visitTryStatement(PsiTryStatement statement2) {
                ExceptionUtil.addExceptions(result2, ExceptionUtil.getTryExceptions(statement2));
            }
        }
        element.accept(new Visitor());
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement psiResourceListElement : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(psiResourceListElement, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiCodeBlock));
        }
        PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
        if (psiCodeBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(psiCodeBlock.getProject()).getControlFlow(psiCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(psiCodeBlock);
                if (!BitUtil.isSet(completionReasons, 1)) {
                    array = ContainerUtil.newArrayList(list2);
                } else {
                    ExceptionUtil.addExceptions(array, list2);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        if (place == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        if ((referenceTypes = method.getThrowsList().getReferencedTypes()).length == 0) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(14);
            }
            return list2;
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
        for (PsiType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor2.substitute(type2), scope)) instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<? extends PsiClassType> exceptions) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        for (PsiClassType psiClassType : exceptions) {
            ExceptionUtil.addException(array, psiClassType);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        Set<PsiClassType> set = ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls ? c -> false : expression2 -> {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            return method == PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
        }));
        if (set == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        return set;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, @NotNull Predicate<? super PsiCallExpression> callFilter) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        if (callFilter == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, callFilter);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression != null ? ExceptionUtil.collectUnhandledExceptions(qualifierExpression, topElement, null, callFilter) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement2 = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement2, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass2 = constructor.getContainingClass();
                PsiClass superClass = aClass2 == null ? null : aClass2.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.getHandlePlace(element, exceptionType, topElement) != HandlePlace.UNHANDLED) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass2 != null) {
                    PsiClassInitializer[] initializers = aClass2.getInitializers();
                    THashSet<PsiClassType> thrownByInitializer = new THashSet<PsiClassType>();
                    for (PsiClassInitializer initializer2 : initializers) {
                        if (initializer2.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions(initializer2.getBody(), initializer2, thrownByInitializer, callFilter);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.getHandlePlace(constructor.getBody(), thrown, topElement) != HandlePlace.UNHANDLED) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions, callFilter);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult;
        PsiElement resolve2;
        if (methodReferenceExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(28);
        }
        if ((resolve2 = (resolveResult = methodReferenceExpression.advancedResolve(false)).getElement()) instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve2, referenceNameElement, topElement, resolveResult.getSubstitutor());
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(29);
            }
            return list2;
        }
        List<PsiClassType> list3 = Collections.emptyList();
        if (list3 == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        return list3;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements;
        if (constructorBody == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        if ((statements = constructorBody.getStatements()).length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        final ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getOwnUnhandledExceptions(element));
                super.visitElement(element);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ArrayUtil.find(elements, expression2) >= 0) {
                    this.visitElement(expression2);
                }
            }

            @Override
            public void visitClass(PsiClass aClass2) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil$1", "visitMethodReferenceExpression"));
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor2);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getOwnUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(34);
        }
        if (element instanceof PsiEnumConstant) {
            PsiMethod method = ((PsiEnumConstant)element).resolveMethod();
            if (method != null) {
                List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions(method, element, null, PsiSubstitutor.EMPTY);
                if (list2 == null) {
                    ExceptionUtil.$$$reportNull$$$0(35);
                }
                return list2;
            }
            List<PsiClassType> list3 = Collections.emptyList();
            if (list3 == null) {
                ExceptionUtil.$$$reportNull$$$0(36);
            }
            return list3;
        }
        if (element instanceof PsiCallExpression) {
            List<PsiClassType> list4 = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)element, null);
            if (list4 == null) {
                ExceptionUtil.$$$reportNull$$$0(37);
            }
            return list4;
        }
        if (element instanceof PsiThrowStatement) {
            List<PsiClassType> list5 = ExceptionUtil.getUnhandledExceptions((PsiThrowStatement)element, null);
            if (list5 == null) {
                ExceptionUtil.$$$reportNull$$$0(38);
            }
            return list5;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            List<PsiClassType> list6 = ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, null);
            if (list6 == null) {
                ExceptionUtil.$$$reportNull$$$0(39);
            }
            return list6;
        }
        if (element instanceof PsiResourceListElement) {
            List<PsiClassType> list7 = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, null);
            if (list7 == null) {
                ExceptionUtil.$$$reportNull$$$0(40);
            }
            return list7;
        }
        List<PsiClassType> list8 = Collections.emptyList();
        if (list8 == null) {
            ExceptionUtil.$$$reportNull$$$0(41);
        }
        return list8;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(44);
        }
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, c -> false);
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(45);
        }
        return list2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, @NotNull Predicate<? super PsiCallExpression> skipCondition) {
        block20: {
            block21: {
                if (methodCall == null) {
                    ExceptionUtil.$$$reportNull$$$0(46);
                }
                if (skipCondition == null) {
                    ExceptionUtil.$$$reportNull$$$0(47);
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        ExceptionUtil.$$$reportNull$$$0(48);
                    }
                    return v0;
                }
                properties = MethodCandidateInfo.getCurrentMethod(methodCall.getArgumentList());
                result = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult(methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        ExceptionUtil.$$$reportNull$$$0(49);
                    }
                    return v2;
                }
                if (skipCondition.test(methodCall)) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        ExceptionUtil.$$$reportNull$$$0(50);
                    }
                    return v3;
                }
                if (properties != null) {
                    PsiUtilCore.ensureValid(method);
                }
                if ((thrownExceptions = method.getThrowsList().getReferencedTypes()).length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        ExceptionUtil.$$$reportNull$$$0(51);
                    }
                    return v4;
                }
                substitutor = result.getSubstitutor();
                if (ExceptionUtil.isArrayClone(method, methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block20;
                containingFile = methodCall.getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), (Function<CandidateInfo, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getUnhandledExceptions$4(org.jetbrains.kotlin.com.intellij.psi.PsiMethod org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo ), (Lorg/jetbrains/kotlin/com/intellij/psi/infos/CandidateInfo;)Lorg/jetbrains/kotlin/com/intellij/openapi/util/Pair;)((PsiMethod)method));
                    if (candidates.isEmpty()) break block20;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions, scope);
lbl41:
                    // 2 sources

                    for (Pair pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                            break block21;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl59
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        ExceptionUtil.$$$reportNull$$$0(54);
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                ExceptionUtil.$$$reportNull$$$0(52);
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl41
lbl59:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY));
            }
            if (v7 == null) {
                ExceptionUtil.$$$reportNull$$$0(53);
            }
            return v7;
        }
        v8 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, substitutor);
        if (v8 == null) {
            ExceptionUtil.$$$reportNull$$$0(55);
        }
        return v8;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<? extends PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator2 = ex.iterator();
        while (iterator2.hasNext()) {
            PsiClassType classType = iterator2.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator2.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor2, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor2.substitute(thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex;
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(56);
        }
        List<PsiClassType> list2 = (ex = ExceptionUtil.getExceptionsFromClose(resource)) != null ? ex : Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(57);
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(58);
        }
        PsiType type2 = resource.getType();
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledCloserExceptions(resource, topElement, type2);
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(59);
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        List<PsiClassType> list2 = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY)) : Collections.emptyList();
        if (list2 == null) {
            ExceptionUtil.$$$reportNull$$$0(60);
        }
        return list2;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType(type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods2 = PsiUtil.getResourceCloserMethodsForType((PsiClassType)type2);
        if (methods2 != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods2) {
                PsiSubstitutor substitutor2;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor2 = TypeConversionUtil.getClassSubstitutor(closerClass, resourceClass, resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor2, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(61);
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiType upperBound;
                PsiClassType classType = null;
                if (subType instanceof PsiClassType) {
                    classType = (PsiClassType)subType;
                } else if (subType instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)subType).getUpperBound()) instanceof PsiClassType) {
                    classType = (PsiClassType)upperBound;
                }
                if (classType == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(throwStatement, classType, topElement) != HandlePlace.UNHANDLED) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            ExceptionUtil.$$$reportNull$$$0(62);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list2 = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(63);
            }
            return list2;
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            List<PsiType> list3 = Collections.singletonList(type2);
            if (list3 == null) {
                ExceptionUtil.$$$reportNull$$$0(64);
            }
            return list3;
        }
        List<PsiType> list4 = Collections.emptyList();
        if (list4 == null) {
            ExceptionUtil.$$$reportNull$$$0(65);
        }
        return list4;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(66);
        }
        if (substitutor2 == null) {
            ExceptionUtil.$$$reportNull$$$0(67);
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                ExceptionUtil.$$$reportNull$$$0(68);
            }
            return list2;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        List<PsiClassType> list3 = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor2, referencedTypes);
        if (list3 == null) {
            ExceptionUtil.$$$reportNull$$$0(69);
        }
        return list3;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor2, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards(substitutor2.substitute(referencedType), false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(element, classType, topElement) != HandlePlace.UNHANDLED) continue;
                result2.add((PsiClassType)type2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(70);
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(71);
        }
        return InheritanceUtil.isInheritor(type2, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type2, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(73);
        }
        return ExceptionUtil.isGeneralExceptionType(type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText;
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(74);
        }
        return "java.lang.Throwable".equals(canonicalText = type2.getCanonicalText()) || "java.lang.Exception".equals(canonicalText);
    }

    @NotNull
    public static HandlePlace getHandlePlace(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, @Nullable PsiElement topElement) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(77);
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            HandlePlace handlePlace = HandlePlace.UNHANDLED;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(78);
            }
            return handlePlace;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(79);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiClass) {
            if (!(parent2 instanceof PsiAnonymousClass)) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(80);
                }
                return handlePlace;
            }
            HandlePlace handlePlace = ExceptionUtil.getHandlePlace(parent2, exceptionType, topElement);
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(81);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent2).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent2).getFunctionalInterfaceType();
            HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType));
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(82);
            }
            return handlePlace;
        }
        if (parent2 instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent2).hasModifierProperty("static")) {
                HandlePlace handlePlace = HandlePlace.UNHANDLED;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(83);
                }
                return handlePlace;
            }
            if (!(parent2.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass2 = ((PsiClassInitializer)parent2).getContainingClass();
                HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass2, exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(84);
                }
                return handlePlace;
            }
        } else if (parent2 instanceof PsiTryStatement) {
            HandlePlace place;
            PsiTryStatement tryStatement = (PsiTryStatement)parent2;
            if (tryStatement.getTryBlock() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace = place;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(85);
                }
                return handlePlace;
            }
            if (tryStatement.getResourceList() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                HandlePlace handlePlace = place;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(86);
                }
                return handlePlace;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(87);
                }
                return handlePlace;
            }
        } else {
            if (parent2 instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent2;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                HandlePlace handlePlace = HandlePlace.fromBoolean(exceptionHandler != null && exceptionHandler.isHandledException(exceptionType));
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(88);
                }
                return handlePlace;
            }
            if (PsiImplUtil.isInServerPage(parent2) && parent2 instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.UNKNOWN;
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(89);
                }
                return handlePlace;
            }
            if (parent2 instanceof PsiFile) {
                HandlePlace handlePlace = HandlePlace.fromBoolean(false);
                if (handlePlace == null) {
                    ExceptionUtil.$$$reportNull$$$0(90);
                }
                return handlePlace;
            }
            if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element) {
                PsiClass aClass3 = ((PsiField)parent2).getContainingClass();
                if (aClass3 != null && !(aClass3 instanceof PsiAnonymousClass) && !((PsiField)parent2).hasModifierProperty("static")) {
                    HandlePlace handlePlace = HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass3, exceptionType));
                    if (handlePlace == null) {
                        ExceptionUtil.$$$reportNull$$$0(91);
                    }
                    return handlePlace;
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : CustomExceptionHandler.KEY.getExtensionList()) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    HandlePlace handlePlace = HandlePlace.UNKNOWN;
                    if (handlePlace == null) {
                        ExceptionUtil.$$$reportNull$$$0(92);
                    }
                    return handlePlace;
                }
            }
        }
        HandlePlace handlePlace = ExceptionUtil.getHandlePlace(parent2, exceptionType, topElement);
        if (handlePlace == null) {
            ExceptionUtil.$$$reportNull$$$0(93);
        }
        return handlePlace;
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(94);
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass2, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(95);
        }
        if (aClass2 == null) {
            return false;
        }
        PsiMethod[] constructors2 = aClass2.getConstructors();
        boolean thrown = constructors2.length != 0;
        for (PsiMethod constructor : constructors2) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    @NotNull
    private static HandlePlace getCaughtPlace(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(96);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(97);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            HandlePlace handlePlace = HandlePlace.UNKNOWN;
            if (handlePlace == null) {
                ExceptionUtil.$$$reportNull$$$0(98);
            }
            return handlePlace;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            HandlePlace.TryCatch tryCatch = new HandlePlace.TryCatch(tryStatement, parameter);
            if (tryCatch == null) {
                ExceptionUtil.$$$reportNull$$$0(99);
            }
            return tryCatch;
        }
        HandlePlace handlePlace = HandlePlace.UNHANDLED;
        if (handlePlace == null) {
            ExceptionUtil.$$$reportNull$$$0(100);
        }
        return handlePlace;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ExceptionUtil.$$$reportNull$$$0(101);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(102);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(103);
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor2) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(104);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(105);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor2);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor2) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(108);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(109);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor2.substitute(classType);
            if (psiType == null || !psiType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ Pair lambda$getUnhandledExceptions$4(PsiMethod method, CandidateInfo info) {
        PsiElement element1 = info.getElement();
        if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element1) && !MethodSignatureUtil.isSuperMethod((PsiMethod)element1, method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
            return Pair.create((PsiMethod)element1, ((MethodCandidateInfo)info).getSubstitutor(false));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 5: 
            case 17: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 11: 
            case 66: 
            case 70: 
            case 102: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 20: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCall";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callFilter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorBody";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 71: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 75: 
            case 77: 
            case 94: 
            case 95: 
            case 97: 
            case 103: 
            case 105: 
            case 106: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwPlace";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownCheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUncheckedExceptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryExceptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethod";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptions";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnUnhandledExceptions";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloserExceptions";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledCloserExceptions";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseThrowTypes";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlePlace";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaughtPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownCheckedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUncheckedExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTryExceptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExceptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 28: 
            case 32: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 61: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptions";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "firstStatementIsConstructorCall";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOwnUnhandledExceptions";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getCloserExceptions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledCloserExceptions";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClone";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedException";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedExceptionOrSuperclass";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralExceptionType";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getHandlePlace";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredBySAMMethod";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "areAllConstructorsThrow";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getCaughtPlace";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "sortExceptionsByHierarchy";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectUnhandledExceptions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HandlePlace {
        public static final HandlePlace UNHANDLED = new HandlePlace(){};
        public static final HandlePlace UNKNOWN = new HandlePlace(){};

        public static HandlePlace fromBoolean(boolean isHandled) {
            return isHandled ? UNKNOWN : UNHANDLED;
        }

        public static class TryCatch
        implements HandlePlace {
            private final PsiTryStatement myTryStatement;
            private final PsiParameter myParameter;

            public TryCatch(PsiTryStatement statement2, PsiParameter parameter) {
                this.myTryStatement = statement2;
                this.myParameter = parameter;
            }
        }
    }
}

