/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import org.jetbrains.annotations.NotNull;

public final class FlexibleTypesKt {
    public static final boolean isFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return $receiver.unwrap() instanceof FlexibleType;
    }

    @NotNull
    public static final FlexibleType asFlexibleType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType = $receiver.unwrap();
        if (unwrappedType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        }
        return (FlexibleType)unwrappedType;
    }

    @NotNull
    public static final SimpleType lowerIfFlexible(@NotNull KotlinType $receiver) {
        SimpleType simpleType2;
        UnwrappedType unwrappedType;
        UnwrappedType $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType2 = $receiver2 = (unwrappedType = $receiver.unwrap());
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$receiver2).getLowerBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType2 = (SimpleType)$receiver2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }

    @NotNull
    public static final SimpleType upperIfFlexible(@NotNull KotlinType $receiver) {
        SimpleType simpleType2;
        UnwrappedType unwrappedType;
        UnwrappedType $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        UnwrappedType unwrappedType2 = $receiver2 = (unwrappedType = $receiver.unwrap());
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$receiver2).getUpperBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType2 = (SimpleType)$receiver2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }
}

