/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;
    private final NameResolver nameResolver;
    private final BinaryVersion metadataVersion;
    private final Function1<ClassId, SourceElement> classSource;

    @NotNull
    public final Collection<ClassId> getAllClassIds() {
        return this.classIdToProto.keySet();
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class classProto = clazz;
        return new ClassData(this.nameResolver, classProto, this.metadataVersion, this.classSource.invoke(classId));
    }

    /*
     * WARNING - void declaration
     */
    public ProtoBasedClassDataFinder(@NotNull ProtoBuf.PackageFragment proto, @NotNull NameResolver nameResolver, @NotNull BinaryVersion metadataVersion2, @NotNull Function1<? super ClassId, ? extends SourceElement> classSource) {
        Map map2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(metadataVersion2, "metadataVersion");
        Intrinsics.checkParameterIsNotNull(classSource, "classSource");
        this.nameResolver = nameResolver;
        this.metadataVersion = metadataVersion2;
        this.classSource = classSource;
        List<ProtoBuf.Class> list2 = proto.getClass_List();
        Intrinsics.checkExpressionValueIsNotNull(list2, "proto.class_List");
        Iterable iterable = list2;
        ProtoBasedClassDataFinder protoBasedClassDataFinder = this;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        void var7_8 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void klass2;
            ProtoBuf.Class clazz = (ProtoBuf.Class)element$iv$iv;
            map2 = destination$iv$iv;
            void v1 = klass2;
            Intrinsics.checkExpressionValueIsNotNull(v1, "klass");
            ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, v1.getFqName());
            map2.put(classId, element$iv$iv);
        }
        protoBasedClassDataFinder.classIdToProto = map2 = destination$iv$iv;
    }
}

