/*
 * Decompiled with CFR 0.152.
 */
package jInst;

import AndroidProjectRepresentation.APICallUtil;
import jInst.Instrumentation.InstrumentGradleHelper;
import jInst.Instrumentation.InstrumentHelper;
import jInst.util.FileUtils;
import jInst.util.XMLParser;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JInst {
    public static TestingFramework inferTestingFramework(String target) {
        String test_target = target.toLowerCase().replace("-", "");
        if (test_target.equals("monkey")) {
            return TestingFramework.MONKEY;
        }
        if (test_target.equals("monkeyrunner")) {
            return TestingFramework.MONKEYRUNNER;
        }
        if (test_target.equals("junit")) {
            return TestingFramework.JUNIT;
        }
        return TestingFramework.OTHER;
    }

    public static InstrumentationType inferInstrumentationType(String target) {
        String test_target = target.toLowerCase().replace("-", "");
        if (test_target.equals("testoriented")) {
            return InstrumentationType.TEST;
        }
        if (test_target.equals("methodorienteed")) {
            return InstrumentationType.METHOD;
        }
        if (test_target.equals("activityoriented")) {
            return InstrumentationType.ACTIVITY;
        }
        if (test_target.equals("annotationoriented")) {
            return InstrumentationType.ANNOTATION;
        }
        return InstrumentationType.NONE;
    }

    public static String getProjectID(String path2) {
        String[] x = path2.split("/");
        return x.length > 0 ? (x[x.length - 1].equals("latest") ? x[x.length - 2] : x[x.length - 1]) : "unknown";
    }

    public static void main(String[] args) {
        String projType;
        switch (projType = args[0]) {
            case "-sdk": {
                if (args.length != 9) {
                    System.err.println("[jInst] Error: Bad arguments length for SDK project. Expected 9, got " + args.length + ".");
                    return;
                }
                String approach = args[8];
                String tName = args[1];
                String workspace = args[2];
                String project = args[3];
                String tests = args[4];
                InstrumentationType instrType = JInst.inferInstrumentationType(args[5]);
                TestingFramework testingFramework = JInst.inferTestingFramework(args[7]);
                String appID = args[7];
                try {
                    APICallUtil apu = (APICallUtil)new APICallUtil().fromJSONObject(new APICallUtil().fromJSONFile(project + "/" + tName + "/" + appID + ".json"));
                    InstrumentHelper helper = new InstrumentHelper(apu, tName, workspace, project, tests, instrType, approach);
                    InstrumentHelper.testingFramework = testingFramework;
                    InstrumentHelper.projectID = JInst.getProjectID(project);
                    helper.generateTransformedProject();
                    helper.generateTransformedTests();
                    FileUtils.writeFile(new File(project + "/" + tName + "/" + appID + ".json"), helper.getAcu().toJSONObject(APICallUtil.proj.projectID).toJSONString());
                    helper.registMethods();
                    XMLParser.buildAppPermissionsJSON(helper.getManifest(), helper.getTransFolder());
                }
                catch (Exception ex) {
                    Logger.getLogger(JInst.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case "-gradle": {
                if (args.length != 10) {
                    System.err.println("[jInst] Error: Bad arguments length for Gradle project. Expected 10, got " + args.length + ".");
                    return;
                }
                String approach = args[9];
                String appID = args[8];
                String tName = args[1];
                String workspace = args[2];
                String project = args[3];
                String manifestSource = args[4];
                String manifestTests = args[5];
                InstrumentationType instrType = JInst.inferInstrumentationType(args[6]);
                TestingFramework testingFramework = JInst.inferTestingFramework(args[7]);
                try {
                    APICallUtil apu = (APICallUtil)new APICallUtil().fromJSONObject(new APICallUtil().fromJSONFile(project + "/" + tName + "/" + appID + ".json"));
                    APICallUtil.proj.projectBuildTool = "gradle";
                    APICallUtil.proj.projectDescription = "";
                    InstrumentGradleHelper helper = new InstrumentGradleHelper(apu, tName, workspace, project, "", manifestSource, manifestTests, instrType, approach);
                    InstrumentGradleHelper.testingFramework = testingFramework;
                    InstrumentGradleHelper.projectID = APICallUtil.proj.projectID;
                    helper.generateTransformedProject();
                    helper.addPermission();
                    FileUtils.writeFile(new File(project + "/" + tName + "/" + appID + ".json"), helper.getAcu().toJSONObject(APICallUtil.proj.projectID).toJSONString());
                    helper.registMethods();
                    XMLParser.buildAppPermissionsJSON(helper.getOriginalManifest(), helper.getTransFolder());
                }
                catch (Exception ex) {
                    Logger.getLogger(JInst.class.getName()).log(Level.SEVERE, null, ex);
                    System.exit(1);
                }
                break;
            }
            default: {
                System.out.println("Unknown argument");
            }
        }
    }

    public static enum TestingFramework {
        MONKEY,
        MONKEYRUNNER,
        JUNIT,
        OTHER;

    }

    public static enum InstrumentationType {
        ACTIVITY,
        ANNOTATION,
        TEST,
        UNITTEST,
        EGIN_METHOD,
        IOMETHOD,
        METHOD,
        NONE;

    }
}

