/*
 * Decompiled with CFR 0.152.
 */
package jInst.Instrumentation;

import AndroidProjectRepresentation.APICallUtil;
import com.github.javaparser.ASTHelper;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.VoidType;
import jInst.Instrumentation.Instrumenter;
import jInst.Instrumentation.KotlinInstrumenter;
import jInst.Instrumentation.Utils.KtlTestsInstrumenterUtil;
import jInst.Instrumentation.Utils.ProjectMethods;
import jInst.Instrumentation.amp.AMPInstrumenter;
import jInst.Instrumentation.hunter.HunterAnnotationInstrumenter;
import jInst.Instrumentation.profiler.Profiler;
import jInst.Instrumentation.profiler.trepn.TrepnLibrary;
import jInst.Instrumentation.profiler.trepn.TrepnProfilerFactory;
import jInst.JInst;
import jInst.ResourceLoader;
import jInst.util.FileUtils;
import jInst.util.KastreeWriterFixed;
import jInst.util.PackageM;
import jInst.util.ParserFixed;
import jInst.util.XMLParser;
import jInst.visitors.ClassOrInterfaceVisitor;
import jInst.visitors.LauncherActivityVisitor;
import jInst.visitors.MethodChangerVisitor;
import jInst.visitors.MethodIdentifierVisitorBackwards;
import jInst.visitors.MethodVisitor;
import jInst.visitors.TestChangerVisitor;
import jInst.visitors.utils.ClassDefs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kastree.ast.Node;

public class InstrumentHelper {
    protected static ArrayList<String> instrumented = new ArrayList();
    protected static ArrayList<String> testCase = new ArrayList();
    protected String launchActivity = "";
    public static final String testClasses = "testClasses.txt";
    protected static String notTestable = "TestCase";
    public static Integer compiledSdkVersion = 0;
    protected String tName;
    protected String workspace;
    public String project;
    protected String tests;
    public static String projectID = "";
    protected String transFolder;
    protected String transTests;
    protected String aux;
    protected String manifest;
    protected String manifestTest;
    protected String projectDesc;
    protected String devPackage;
    protected ArrayList<PackageM> packages;
    protected String originalManifest;
    protected JInst.InstrumentationType type;
    private TestingApproach approach = TestingApproach.WhiteBox;
    public static JInst.TestingFramework testingFramework;
    public static ProjectMethods allMethods;
    protected Map<String, String> testType = new HashMap<String, String>();
    private static ClassDefs appPackage;
    protected static Instrumenter instrumenter;
    private APICallUtil acu = new APICallUtil();
    static boolean stateSetup;

    public List<String> findAllManifests() {
        try {
            return Files.find(Paths.get(this.transFolder, new String[0]), 6, (p, bfa) -> bfa.isRegularFile() && p.getFileName().toString().equals("AndroidManifest.xml"), new FileVisitOption[0]).map(x -> x.toAbsolutePath().toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public InstrumentHelper(APICallUtil apu, String tName, String work, String proj2, String tests, JInst.InstrumentationType type2, String approach) {
        this.acu = apu;
        this.tName = tName;
        this.workspace = work;
        this.project = proj2;
        this.tests = tests;
        this.transFolder = this.project + "/" + tName + "/";
        this.transTests = this.transFolder + "tests/";
        this.manifest = this.transFolder + "AndroidManifest.xml";
        this.manifestTest = this.transTests + "AndroidManifest.xml";
        this.projectDesc = this.project + ".project";
        this.aux = this.transFolder + "_aux_/";
        this.devPackage = "";
        this.packages = new ArrayList();
        this.type = type2;
        instrumented.add("ActivityUnitTestCase");
        instrumented.add("ActivityIntrumentationTestCase2");
        instrumented.add("ActivityTestCase");
        instrumented.add("ProviderTestCase");
        instrumented.add("SingleLaunchActivityTestCase");
        instrumented.add("SyncBaseInstrumentation");
        instrumented.add("ActivityInstrumentationTestCase");
        instrumented.add("ActivityInstrumentationTestCase2");
        testCase.add("AndroidTestCase");
        testCase.add("ApplicationTestCase");
        testCase.add("LoaderTestCase");
        testCase.add("ProviderTestCase2");
        testCase.add("ServiceTestCase");
    }

    public String getTransFolder() {
        return this.transFolder;
    }

    public void setTransFolder(String transFolder) {
        this.transFolder = transFolder;
    }

    public static boolean isApplicationClass(String s) {
        return appPackage.getName() != null;
    }

    public static String getApplicationClass() {
        return appPackage.getName();
    }

    public static String getApplicationFullName() {
        return appPackage.getPack() + "." + appPackage.getName();
    }

    public InstrumentHelper() {
    }

    public void setInstrumentationType(JInst.InstrumentationType type2) {
        TrepnProfilerFactory pfact = new TrepnProfilerFactory();
        if (type2 == JInst.InstrumentationType.TEST) {
            instrumenter = pfact.createTestOrientedProfiler();
        } else if (type2 == JInst.InstrumentationType.METHOD) {
            instrumenter = pfact.createMethodOrientedProfiler();
        } else if (type2 == JInst.InstrumentationType.ACTIVITY) {
            instrumenter = new AMPInstrumenter();
            this.findLauncher();
            this.launchActivity = XMLParser.getLauncher();
        } else if (type2 == JInst.InstrumentationType.ANNOTATION) {
            instrumenter = new HunterAnnotationInstrumenter();
        }
    }

    public String getManifest() {
        return this.manifest;
    }

    public String getOriginalManifest() {
        return this.originalManifest;
    }

    public void setCompiledSdkVersion(String filename) {
        compiledSdkVersion = InstrumentHelper.getSdkVersion(filename);
    }

    public void addTestType(String path2, String testType) {
        this.testType.put(path2, testType);
    }

    public String getTestType(String filepath) {
        return this.testType.get(filepath);
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
        this.transFolder = project + this.tName + "/";
        this.transTests = this.transFolder + "tests/";
        this.manifest = this.transFolder + "AndroidManifest.xml";
        this.manifestTest = this.transTests + "AndroidManifest.xml";
        this.devPackage = "";
    }

    public String getTests() {
        return this.tests;
    }

    public void setTests(String tests) {
        this.tests = tests;
    }

    public APICallUtil getAcu() {
        return this.acu;
    }

    public void setAcu(APICallUtil acu) {
        this.acu = acu;
    }

    public static int getSdkVersion(String filename) {
        if (!filename.endsWith("build.gradle")) {
            return 0;
        }
        int version = 0;
        BufferedReader b = null;
        try {
            String s = "";
            b = new BufferedReader(new FileReader(filename));
            while ((s = b.readLine()) != null) {
                String[] tokens;
                String s1 = new String(s);
                if (!s.matches(".*compileSdkVersion.*")) continue;
                for (String tok : tokens = s.trim().split("(\\s+)")) {
                    if (!tok.chars().allMatch(Character::isDigit)) continue;
                    return Integer.parseInt(tok.trim());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }

    public void generateTransformedTests() throws Exception {
        File[] listOfFiles;
        File fProject = new File(this.tests);
        File fTransf = new File(this.transTests);
        fTransf.mkdir();
        for (File f : listOfFiles = fProject.listFiles()) {
            if (f.isDirectory()) {
                if (!f.getName().equals("src") && !f.getName().equals(this.tName)) {
                    FileUtils.copyFolder(f, new File(this.transTests + f.getName()));
                    continue;
                }
                if (!f.getName().equals("src")) continue;
                this.instrumentSource(f, new File(this.transTests + "src"));
                continue;
            }
            if (!f.isFile()) continue;
            File aux = new File(this.transTests + f.getName());
            aux.createNewFile();
            FileUtils.copyFile(f, aux);
        }
        File libsT = new File(this.transTests + "libs");
        if (!libsT.exists()) {
            libsT.mkdir();
        }
        this.changeRunner();
    }

    public void generateTransformedProject() throws Exception {
        File[] listOfFiles;
        File fProject = new File(this.project);
        File fTransf = new File(this.transFolder);
        fTransf.mkdir();
        for (File f : listOfFiles = fProject.listFiles()) {
            if (f.isDirectory()) {
                if (!(f.getName().equals("src") || f.getName().equals(this.tName) || this.tests.contains(f.getAbsolutePath()))) {
                    FileUtils.copyFolder(f, new File(this.transFolder + f.getName()));
                    continue;
                }
                if (!f.getName().equals("src")) continue;
                this.instrumentSource(f, new File(this.transFolder + "src"));
                continue;
            }
            if (!f.isFile()) continue;
            File aux = new File(this.transFolder + f.getName());
            FileUtils.copyFile(f, aux);
        }
        String allMethods = "";
        FileUtils.copyAll(MethodChangerVisitor.getPackages(), this.packages);
        for (PackageM p : this.packages) {
            allMethods = allMethods + p.toString();
        }
        File auxF = new File(this.aux);
        auxF.mkdir();
        FileUtils.writeFile(new File(this.aux + "AllMethods"), allMethods);
        this.packages.clear();
        MethodChangerVisitor.restartPackages();
        this.addPermission();
        XMLParser.addLibOverrideToManifests(this.findAllManifests());
    }

    protected void findLauncher() {
        XMLParser.parseManifest(this.originalManifest);
        this.devPackage = XMLParser.getBuildPackage();
    }

    protected void changeRunner() {
        File ax = new File(this.manifestTest);
        if (ax.exists()) {
            XMLParser.editRunner(this.manifestTest);
        }
    }

    public void addPermission() {
        XMLParser.editManifest(this.manifest);
    }

    protected void editProjectDesc() {
        XMLParser.editProjectDesc(this.transFolder + ".project");
        XMLParser.editProjectDesc(this.transTests + ".project");
        XMLParser.editClasspath(this.transTests + ".classpath");
    }

    protected void instrumentSource(File src, File dest) throws Exception {
        if (src.isDirectory()) {
            String[] files2;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file2 : files2 = src.list()) {
                File srcFile = new File(src, file2);
                File destFile = new File(dest, file2);
                this.instrumentSource(srcFile, destFile);
            }
        } else if (src.getAbsolutePath().endsWith(".java")) {
            String res2 = "";
            if (this.isTestCase(src)) {
                if (InstrumentHelper.hasToInstrumentProjectTests()) {
                    res2 = this.transformTest(src.getAbsolutePath());
                } else {
                    FileUtils.copyFile(src, dest);
                }
            } else {
                res2 = this.transform(src.getAbsolutePath());
            }
            if (!res2.equals("")) {
                dest.createNewFile();
                FileUtils.writeFile(dest, res2);
            } else {
                dest.delete();
            }
        } else if (src.getAbsolutePath().endsWith(".kt")) {
            String res3 = "";
            res3 = this.transformKotlin(src.getAbsolutePath());
            if (!res3.equals("")) {
                dest.createNewFile();
                FileUtils.writeFile(dest, res3);
            } else {
                dest.delete();
            }
            if (!res3.equals("")) {
                dest.createNewFile();
                FileUtils.writeFile(dest, res3);
            } else {
                dest.delete();
            }
        } else {
            this.setCompiledSdkVersion(src.getAbsolutePath());
            FileUtils.copyFile(src, dest);
        }
    }

    public static boolean hasToInstrumentProjectTests() {
        return testingFramework != JInst.TestingFramework.MONKEY && testingFramework != JInst.TestingFramework.MONKEYRUNNER;
    }

    protected boolean isInstrumentedTestCase(String filename) {
        try {
            return filename.contains("androidTest");
        }
        catch (Exception e) {
            System.out.println("[jInst] error in isInstrumentedtestCase");
            return false;
        }
    }

    protected void setupAppClass(String pack, String file2) {
        if (!stateSetup) {
            String appclass = XMLParser.getApplicationClass(this.originalManifest);
            if (appclass == null) {
                this.CreateAppClass(pack, file2);
                appPackage = new ClassDefs(pack, "TrepApp");
            } else {
                String[] sp = appclass.split("\\.");
                appPackage = new ClassDefs(pack, sp[sp.length - 1]);
            }
            stateSetup = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transform(String file2) throws Exception {
        CompilationUnit cu;
        try (FileInputStream in = new FileInputStream(file2);){
            cu = JavaParser.parse(in, "utf-8", false);
        }
        if (cu.getPackage() == null) {
            return "";
        }
        String pack = cu.getPackage().getName().toString();
        if (cu.getTypes() == null || cu.getTypes().isEmpty()) {
            return cu.toString();
        }
        String cl = cu.getTypes().get(0).getName();
        ClassDefs cDef = new ClassDefs();
        cDef.setName(cl);
        cDef.setPack(pack);
        String classDefinition = cDef.getClassDefinition();
        if (this.type == JInst.InstrumentationType.ACTIVITY) {
            System.out.println("ACTIVITY");
            if (classDefinition.equals(this.launchActivity)) {
                cDef.setLauncher(true);
                cDef.setActivity(true);
                List<ImportDeclaration> imp2 = instrumenter.getImports();
                if (cu.getImports() != null) {
                    cu.getImports().addAll(imp2);
                } else {
                    cu.setImports(new LinkedList<ImportDeclaration>());
                    cu.getImports().addAll(imp2);
                }
                LauncherActivityVisitor v2 = new LauncherActivityVisitor();
                v2.visit(cu, new AMPInstrumenter());
            }
        } else {
            String classDec;
            List<ImportDeclaration> imp2 = instrumenter.getImports();
            if (cu.getImports() != null) {
                cu.getImports().addAll(imp2);
            } else {
                cu.setImports(new LinkedList<ImportDeclaration>());
                cu.getImports().addAll(imp2);
            }
            if (InstrumentHelper.isApplicationClass(pack + "." + cl)) {
                ImportDeclaration im = new ImportDeclaration(ASTHelper.createNameExpr("android.content.Context"), false, false);
                if (cu.getImports() != null) {
                    cu.getImports().add(im);
                } else {
                    cu.setImports(new LinkedList<ImportDeclaration>());
                    cu.getImports().add(im);
                }
            }
            if (!(classDec = cu.getTypes().get(0).getClass().getName()).contains("ClassOrInterfaceDeclaration")) {
                return cu.toString();
            }
            ClassOrInterfaceDeclaration x = (ClassOrInterfaceDeclaration)cu.getTypes().get(0);
            String l = pack + "." + cl;
            if (this.devPackage.equals(l)) {
                cDef.setLauncher(true);
            }
            if (!x.isInterface()) {
                if (x.getExtends() != null) {
                    for (ClassOrInterfaceType ci : x.getExtends()) {
                        String name = ci.getName();
                        if (!name.contains("Activity")) continue;
                        cDef.setActivity(true);
                    }
                }
                if (this.type == JInst.InstrumentationType.TEST) {
                    System.out.println("NOT ACTIVITY - TEST");
                    ClassOrInterfaceVisitor v3 = new ClassOrInterfaceVisitor();
                    v3.setCu(cu);
                    v3.setTracedMethod(true);
                    v3.visit(cu, cDef);
                }
                MethodChangerVisitor v1 = new MethodChangerVisitor();
                v1.setCu(cu);
                v1.setTracedMethod(this.type != JInst.InstrumentationType.METHOD);
                v1.visit(cu, cDef);
            }
        }
        return cu.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transformTest(String file2) throws Exception {
        CompilationUnit cu;
        FileInputStream in = new FileInputStream(file2);
        ClassDefs cDef = new ClassDefs();
        boolean isJunitTest = false;
        boolean isTestable = false;
        boolean isJunitTest4 = false;
        try {
            cu = JavaParser.parse(in, "utf-8", false);
        }
        finally {
            in.close();
        }
        String pack = cu.getPackage().getName().toString();
        String cl = cu.getTypes().get(0).getName();
        cDef.setName(cl);
        cDef.setPack(pack);
        cDef.setAppName(this.devPackage);
        ImportDeclaration imp2 = null;
        ImportDeclaration imp4 = null;
        ClassOrInterfaceDeclaration x = (ClassOrInterfaceDeclaration)cu.getTypes().get(0);
        if (x.getExtends() != null) {
            for (ClassOrInterfaceType ci : x.getExtends()) {
                String name = ci.getName();
                String name2 = ci.getName().replaceAll("<.*?>", "");
                if (testCase.contains(name)) {
                    cDef.setInstrumented(false);
                    isTestable = true;
                    continue;
                }
                if (instrumented.contains(name)) {
                    cDef.setInstrumented(true);
                    isTestable = true;
                    continue;
                }
                if (!notTestable.equals(name)) continue;
                isJunitTest = true;
            }
        }
        if (this.testType.get(file2).equals("Junit4")) {
            isTestable = true;
            cDef.setInstrumented(true);
            cDef.setJunit4(true);
        }
        if (this.testType.get(file2).equals("Other")) {
            cDef.setOther(true);
            isTestable = true;
        } else if (this.testType.get(file2).equals("SuiteJunit4")) {
            isTestable = true;
            cDef.setInstrumented(true);
            cDef.setJunit4suite(true);
        }
        if (isTestable) {
            MethodDeclaration newTearDown;
            LinkedList<AnnotationExpr> anot;
            MethodDeclaration newSetUp;
            LinkedList<ReferenceType> _throws;
            TestChangerVisitor t = new TestChangerVisitor();
            TestChangerVisitor.traceMethod = this.type == JInst.InstrumentationType.TEST;
            t.visit(cu, cDef);
            if (instrumenter instanceof HunterAnnotationInstrumenter) {
                return cu.toString();
            }
            if (cDef.isJunit4suite()) {
                ArrayList<Statement> body;
                MethodCallExpr getContext;
                if (!cDef.isBeforeClass()) {
                    _throws = new LinkedList<ReferenceType>();
                    newSetUp = new MethodDeclaration();
                    newSetUp.setName("before");
                    newSetUp.setModifiers(1);
                    newSetUp.setThrows(_throws);
                    newSetUp.setType(new VoidType());
                    anot = new LinkedList<AnnotationExpr>();
                    anot.add(new MarkerAnnotationExpr(new NameExpr("BeforeClass")));
                    newSetUp.setAnnotations(anot);
                    newSetUp.setBody(new BlockStmt());
                    getContext = new MethodCallExpr();
                    if (!cDef.isInstrumented()) {
                        getContext.setName("this.getContext");
                    } else if (cDef.isOther()) {
                        getContext.setName("this.getInstrumentation().getContext");
                    } else {
                        getContext.setName("InstrumentationRegistry.getTargetContext");
                    }
                    MethodCallExpr mcS = ((Profiler)instrumenter).startProfiler(getContext);
                    body = new ArrayList<Statement>();
                    body.add(new ExpressionStmt(mcS));
                    newSetUp.getBody().setStmts(body);
                    x.getMembers().add(0, newSetUp);
                    imp2 = new ImportDeclaration(ASTHelper.createNameExpr("org.junit.BeforeClass"), false, false);
                }
                if (!cDef.isAfterClass()) {
                    _throws = new LinkedList();
                    newTearDown = new MethodDeclaration();
                    newTearDown.setName("after");
                    newTearDown.setThrows(_throws);
                    newTearDown.setModifiers(1);
                    newTearDown.setType(new VoidType());
                    anot = new LinkedList();
                    anot.add(new MarkerAnnotationExpr(new NameExpr("AfterClass")));
                    newTearDown.setAnnotations(anot);
                    newTearDown.setBody(new BlockStmt());
                    getContext = new MethodCallExpr();
                    if (!cDef.isInstrumented()) {
                        getContext.setName("this.getContext");
                    } else if (cDef.isOther()) {
                        getContext.setName("this.getInstrumentation().getContext");
                    } else {
                        getContext.setName("InstrumentationRegistry.getTargetContext");
                    }
                    MethodCallExpr mcT = ((Profiler)instrumenter).stopProfiler(getContext);
                    body = new ArrayList();
                    body.add(new ExpressionStmt(mcT));
                    newTearDown.getBody().setStmts(body);
                    x.getMembers().add(Math.max(x.getMembers().size() - 1, 0), newTearDown);
                    imp4 = new ImportDeclaration(ASTHelper.createNameExpr("org.junit.AfterClass"), false, false);
                }
            } else if (!cDef.isSuite()) {
                if (cDef.isJunit4()) {
                    ArrayList<Statement> body;
                    MethodCallExpr getContext;
                    if (!cDef.hasBefore()) {
                        _throws = new LinkedList();
                        newSetUp = new MethodDeclaration();
                        newSetUp.setName("before");
                        newSetUp.setModifiers(1);
                        newSetUp.setThrows(_throws);
                        newSetUp.setType(new VoidType());
                        anot = new LinkedList();
                        anot.add(new MarkerAnnotationExpr(new NameExpr("Before")));
                        newSetUp.setAnnotations(anot);
                        newSetUp.setBody(new BlockStmt());
                        getContext = new MethodCallExpr();
                        if (!cDef.isInstrumented()) {
                            getContext.setName("this.getContext");
                        } else if (cDef.isOther()) {
                            getContext.setName("this.getInstrumentation().getContext");
                        } else {
                            getContext.setName("InstrumentationRegistry.getTargetContext");
                        }
                        MethodCallExpr mcS = ((Profiler)instrumenter).startProfiler(getContext);
                        body = new ArrayList<Statement>();
                        body.add(new ExpressionStmt(mcS));
                        if (compiledSdkVersion > 22) {
                            ExpressionStmt exp = new ExpressionStmt(TrepnLibrary.getReadPermissions());
                            ExpressionStmt exp1 = new ExpressionStmt(TrepnLibrary.getWritePermissions());
                            ExpressionStmt ex2 = new ExpressionStmt(TrepnLibrary.getTrepnlibReadPermissions());
                            ExpressionStmt exp3 = new ExpressionStmt(TrepnLibrary.getTrepnlibWritePermissions());
                            body.add(0, exp);
                            body.add(0, exp1);
                            body.add(0, ex2);
                            body.add(0, exp3);
                        }
                        newSetUp.getBody().setStmts(body);
                        x.getMembers().add(0, newSetUp);
                        imp2 = new ImportDeclaration(ASTHelper.createNameExpr("org.junit.Before"), false, false);
                    }
                    if (!cDef.hasAfter()) {
                        _throws = new LinkedList();
                        newTearDown = new MethodDeclaration();
                        newTearDown.setName("after");
                        newTearDown.setModifiers(1);
                        newTearDown.setType(new VoidType());
                        anot = new LinkedList();
                        anot.add(new MarkerAnnotationExpr(new NameExpr("After")));
                        newTearDown.setAnnotations(anot);
                        newTearDown.setBody(new BlockStmt());
                        getContext = new MethodCallExpr();
                        if (!cDef.isInstrumented()) {
                            getContext.setName("this.getContext");
                        } else if (cDef.isOther()) {
                            getContext.setName("this.getInstrumentation().getContext");
                        } else {
                            getContext.setName("InstrumentationRegistry.getTargetContext");
                        }
                        MethodCallExpr mcT = ((Profiler)instrumenter).stopProfiler(getContext);
                        body = new ArrayList();
                        body.add(new ExpressionStmt(mcT));
                        newTearDown.getBody().setStmts(body);
                        x.getMembers().add(x.getMembers().size() - 1 > 0 ? x.getMembers().size() - 1 : 0, newTearDown);
                        imp4 = new ImportDeclaration(ASTHelper.createNameExpr("org.junit.After"), false, false);
                    }
                } else {
                    ArrayList<Statement> body;
                    MethodCallExpr getContext;
                    if (!cDef.hasSetUp()) {
                        _throws = new LinkedList();
                        newSetUp = new MethodDeclaration();
                        newSetUp.setName("setUp");
                        newSetUp.setModifiers(1);
                        newSetUp.setType(new VoidType());
                        anot = new LinkedList();
                        anot.add(new MarkerAnnotationExpr(new NameExpr("Override")));
                        newSetUp.setAnnotations(anot);
                        newSetUp.setBody(new BlockStmt());
                        MethodCallExpr superSetUp = new MethodCallExpr();
                        superSetUp.setName("super.setUp");
                        getContext = new MethodCallExpr();
                        if (!cDef.isInstrumented()) {
                            getContext.setName("this.getContext");
                        } else if (cDef.isOther()) {
                            getContext.setName("this.getInstrumentation().getContext");
                        } else {
                            getContext.setName("InstrumentationRegistry.getTargetContext");
                        }
                        MethodCallExpr mcS = ((Profiler)instrumenter).startProfiler(getContext);
                        body = new ArrayList<Statement>();
                        body.add(new ExpressionStmt(mcS));
                        body.add(new ExpressionStmt(superSetUp));
                        if (compiledSdkVersion > 22) {
                            ExpressionStmt exp = new ExpressionStmt(TrepnLibrary.getReadPermissions());
                            ExpressionStmt exp1 = new ExpressionStmt(TrepnLibrary.getWritePermissions());
                            ExpressionStmt exp2 = new ExpressionStmt(TrepnLibrary.getTrepnlibReadPermissions());
                            ExpressionStmt exp3 = new ExpressionStmt(TrepnLibrary.getTrepnlibWritePermissions());
                            body.add(0, exp);
                            body.add(0, exp1);
                            body.add(0, exp2);
                            body.add(0, exp3);
                        }
                        newSetUp.getBody().setStmts(body);
                        x.getMembers().add(0, newSetUp);
                    }
                    if (!cDef.hasTearDown()) {
                        _throws = new LinkedList();
                        newTearDown = new MethodDeclaration();
                        newTearDown.setName("tearDown");
                        newTearDown.setThrows(_throws);
                        newTearDown.setModifiers(1);
                        newTearDown.setType(new VoidType());
                        anot = new LinkedList();
                        anot.add(new MarkerAnnotationExpr(new NameExpr("Override")));
                        newTearDown.setAnnotations(anot);
                        newTearDown.setBody(new BlockStmt());
                        MethodCallExpr superTearDown = new MethodCallExpr();
                        superTearDown.setName("super.tearDown");
                        getContext = new MethodCallExpr();
                        if (!cDef.isInstrumented()) {
                            getContext.setName("this.getContext");
                        } else if (cDef.isOther()) {
                            getContext.setName("this.getInstrumentation().getContext");
                        } else {
                            getContext.setName("InstrumentationRegistry.getTargetContext");
                        }
                        MethodCallExpr mcT = ((Profiler)instrumenter).stopProfiler(getContext);
                        body = new ArrayList();
                        body.add(new ExpressionStmt(mcT));
                        body.add(new ExpressionStmt(superTearDown));
                        newTearDown.getBody().setStmts(body);
                        x.getMembers().add(x.getMembers().size() - 1 > 0 ? x.getMembers().size() - 1 : 0, newTearDown);
                    }
                }
            }
            ImportDeclaration imp1 = ((Profiler)instrumenter).getLibrary();
            ImportDeclaration imp3 = null;
            if (cDef.isJunit4() || cDef.isJunit4suite()) {
                imp3 = new ImportDeclaration(ASTHelper.createNameExpr("android.support.test.InstrumentationRegistry"), false, false);
            }
            if (cu.getImports() != null) {
                cu.getImports().add(imp1);
                if (imp3 != null) {
                    cu.getImports().add(imp3);
                }
                if (imp2 != null) {
                    cu.getImports().add(imp2);
                }
                if (imp4 != null) {
                    cu.getImports().add(imp4);
                }
            } else {
                cu.setImports(new LinkedList<ImportDeclaration>());
                cu.getImports().add(imp1);
                if (imp2 != null) {
                    cu.getImports().add(imp2);
                }
                if (imp4 != null) {
                    cu.getImports().add(imp4);
                }
                if (imp3 != null) {
                    cu.getImports().add(imp3);
                }
            }
        } else if (x.getExtends() != null && isJunitTest) {
            new MethodVisitor().visit(cu, cDef);
            if (cDef.hasTests()) {
                return "";
            }
        }
        return cu.toString();
    }

    public void CreateAppClass(String pack, String file2) {
        String[] sp = file2.split("/");
        String pathToFile = "";
        if (sp.length - 1 > 0) {
            for (int i = 0; i < sp.length - 1; ++i) {
                if (!(pathToFile = pathToFile + sp[i] + "/").equals(this.project)) continue;
                pathToFile = pathToFile + this.tName + "/";
            }
        }
        pathToFile = pathToFile + "TrepApp.java";
        XMLParser.addApplicationName(this.manifest, pack + ".TrepApp");
        File src = new File("TrepApp.java");
        File dest = new File(pathToFile);
        try {
            FileUtils.copyFile(src, dest);
        }
        catch (Exception e) {
            System.out.println("[JInst] CreateAppClass error in copying appfile ");
        }
        appPackage = new ClassDefs(pack, "TrepApp");
        CompilationUnit cu = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(dest);
            cu = JavaParser.parse(in, null, false);
            PackageDeclaration p = new PackageDeclaration();
            p.setName(ASTHelper.createNameExpr(pack));
            cu.setPackage(p);
            FileUtils.writeFile(dest, cu.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isTestCase(File src) throws IOException {
        BufferedReader b = new BufferedReader(new FileReader(src));
        String s = "";
        boolean res2 = false;
        while ((s = b.readLine()) != null) {
            if (s.matches(".*(@LargeTest|@MediumTest|@SmallTest|@Smoke|@Suppress)") || s.matches(".* class .+ extends (TestCase|ActivityUnitTestCase|ActivityInstrumentationTestCase2|ActivityTestCase|ProviderTestCase|SingleLaunchActivityTestCase|SyncBaseInstrumentation|ActivityInstrumentationTestCase|ActivityInstrumentationTestCase2|AndroidTestCase|ApplicationTestCase|LoaderTestCase|ProviderTestCase2|ServiceTestCasefail).*") || s.matches(".*(TestCase|ActivityUnitTestCase|ActivityInstrumentationTestCase2|ActivityTestCase|ProviderTestCase|SingleLaunchActivityTestCase|SyncBaseInstrumentation|ActivityInstrumentationTestCase|ActivityInstrumentationTestCase2|AndroidTestCase|ApplicationTestCase|LoaderTestCase|ProviderTestCase2|ServiceTestCasefail).*")) {
                try {
                    FileInputStream in = new FileInputStream(src);
                    CompilationUnit compilationUnit = JavaParser.parse(in, null, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addTestType(src.getAbsolutePath(), "Other");
                res2 = true;
            } else if (s.matches(".*@Test.*")) {
                res2 = true;
                this.addTestType(src.getAbsolutePath(), "Junit4");
            }
            if (s.matches(".*@SuiteClass.*")) {
                this.addTestType(src.getAbsolutePath(), "SuiteJunit4");
                res2 = true;
            }
            if (!res2) continue;
            break;
        }
        return res2;
    }

    public boolean isTestCaseInstrumented(File src) throws IOException {
        BufferedReader b = new BufferedReader(new FileReader(src));
        String s = "";
        boolean res2 = false;
        while ((s = b.readLine()) != null) {
            String s1 = new String(s);
            if (s.matches(".* class .+ extends (ActivityUnitTestCase|ActivityIntrumentationTestCase2|ActivityTestCase|ProviderTestCase|SingleLaunchActivityTestCase|SyncBaseInstrumentation|ActivityInstrumentationTestCase).*")) {
                return res2;
            }
            if (!s.matches(".*import[ \\t]android.*")) continue;
            return true;
        }
        return res2;
    }

    public ClassDefs getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(ClassDefs appPackage) {
        InstrumentHelper.appPackage = appPackage;
    }

    public static Instrumenter getInstrumenter() {
        return instrumenter;
    }

    public static String wrapMethod(MethodDeclaration n, ClassDefs arg, String hash) {
        List<String> ll = MethodIdentifierVisitorBackwards.getMethodDefinitionToks(n);
        return arg.getPack() + "." + String.join((CharSequence)".", ll) + "->" + n.getName() + "|" + hash;
    }

    public static String wrapMethod(ConstructorDeclaration n, ClassDefs arg, String hash) {
        List<String> ll = MethodIdentifierVisitorBackwards.getMethodDefinitionToks(n);
        return arg.getPack() + "." + String.join((CharSequence)".", ll) + "->" + n.getName() + "|" + hash;
    }

    public String transformKotlin(String absolutePath) {
        KotlinInstrumenter kt = null;
        try {
            if (this.type == JInst.InstrumentationType.TEST) {
                kt = new KotlinInstrumenter(JInst.InstrumentationType.TEST, JavaParser.parseExpression("null"));
            } else if (this.type == JInst.InstrumentationType.METHOD) {
                kt = new KotlinInstrumenter(JInst.InstrumentationType.METHOD, JavaParser.parseExpression("null"));
            } else if (this.type == JInst.InstrumentationType.ACTIVITY) {
                kt = new KotlinInstrumenter(JInst.InstrumentationType.ACTIVITY, JavaParser.parseExpression("null"));
            } else if (this.type == JInst.InstrumentationType.ANNOTATION) {
                kt = new KotlinInstrumenter(JInst.InstrumentationType.ANNOTATION, JavaParser.parseExpression("null"));
            } else {
                System.out.println("bad instrumentation type (transformKotlin) ");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ParserFixed p = new ParserFixed();
        Node.File f = p.parseFile(FileUtils.stringFromFile(absolutePath), false);
        if (KtlTestsInstrumenterUtil.Companion.isTestFile(f) && this.isWhiteBox()) {
            return KastreeWriterFixed.Companion.write(kt.instrumentTestFile(f), null);
        }
        if (this.isWhiteBox() && this.type == JInst.InstrumentationType.ACTIVITY && KtlTestsInstrumenterUtil.Companion.isLauncherActivity(f, this.launchActivity)) {
            return KastreeWriterFixed.Companion.write(kt.instrument(f), null);
        }
        if (this.isWhiteBox() && this.type != JInst.InstrumentationType.ACTIVITY) {
            return KastreeWriterFixed.Companion.write(kt.instrument(f), null);
        }
        if (this.isWhiteBox() && this.type != JInst.InstrumentationType.ANNOTATION) {
            return KastreeWriterFixed.Companion.write(kt.instrument(f), null);
        }
        return KastreeWriterFixed.Companion.write(f, null);
    }

    public String transformKotlinTest(String absolutePath) {
        KotlinInstrumenter kt = null;
        try {
            if (this.type == JInst.InstrumentationType.TEST) {
                kt = new KotlinInstrumenter(JInst.InstrumentationType.TEST, JavaParser.parseExpression("null"));
            } else if (this.type == JInst.InstrumentationType.METHOD) {
                kt = new KotlinInstrumenter(JInst.InstrumentationType.METHOD, JavaParser.parseExpression("null"));
            } else {
                System.out.println("bad instrumentation type (transformKotlin) ");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ParserFixed p = new ParserFixed();
        String ret = KastreeWriterFixed.Companion.write(kt.instrumentTestFile(p.parseFile(FileUtils.stringFromFile(absolutePath), false)), null);
        return ret;
    }

    public static void registMethods() {
        ResourceLoader l = new ResourceLoader();
        File f = new File("allMethods.json");
        if (f.exists()) {
            f.delete();
        }
        try {
            FileUtils.writeFile(f, allMethods.convertTOJSONObject());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("[Jinst] An error occured while appending to allMethods file ");
        }
    }

    public boolean isBlackBox() {
        return this.approach == TestingApproach.Blackbox;
    }

    public boolean isWhiteBox() {
        return this.approach == TestingApproach.WhiteBox;
    }

    public TestingApproach getApproach() {
        return this.approach;
    }

    public void setApproach(TestingApproach approach) {
        this.approach = approach;
    }

    public void setApproach(String approach) {
        String app = approach.replace("-", "").toLowerCase();
        this.approach = app.contains("black") ? TestingApproach.Blackbox : TestingApproach.WhiteBox;
    }

    static {
        allMethods = new ProjectMethods();
        appPackage = new ClassDefs();
        stateSetup = false;
    }

    static enum TestingApproach {
        Blackbox,
        WhiteBox;

    }
}

