/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.internal.Utils;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public class StringLiteralExpr
extends LiteralExpr {
    protected String value;

    public StringLiteralExpr() {
        this.value = "";
    }

    public StringLiteralExpr(String value) {
        if (value.contains("\n") || value.contains("\r")) {
            throw new IllegalArgumentException("Illegal literal expression: newlines (line feed or carriage return) have to be escaped");
        }
        this.value = value;
    }

    public static StringLiteralExpr escape(String string) {
        return new StringLiteralExpr(Utils.escapeEndOfLines(string));
    }

    @Deprecated
    public StringLiteralExpr(int beginLine, int beginColumn, int endLine, int endColumn, String value) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), value);
    }

    public StringLiteralExpr(Range range, String value) {
        super(range);
        this.value = value;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v2, A arg) {
        return v2.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v2, A arg) {
        v2.visit(this, arg);
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }
}

