/*
 * Decompiled with CFR 0.152.
 */
package greenlab.org.ebugslocator.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import greenlab.org.ebugslocator.utils.Reporter;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalGetterDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Class<? extends Detector> DETECTOR_CLASS = InternalGetterDetector.class;
    private static final EnumSet<Scope> DETECTOR_SCOPE = Scope.JAVA_FILE_SCOPE;
    private static final Implementation IMPLEMENTATION = new Implementation(DETECTOR_CLASS, DETECTOR_SCOPE);
    private static final String ISSUE_ID = "InternalGetter";
    private static final String ISSUE_DESCRIPTION = "Avoid Using Internal Getters";
    private static final String ISSUE_EXPLANATION = "Calling a getter inside the same class leads to unnecessary computational effort. Therefore, the execution time and energy consumption of your application may also increase";
    private static final Category ISSUE_CATEGORY = Category.PERFORMANCE;
    private static final int ISSUE_PRIORITY = 5;
    private static final Severity ISSUE_SEVERITY = Severity.WARNING;
    public static final Issue ISSUE = Issue.create((String)"InternalGetter", (String)"Avoid Using Internal Getters", (String)"Calling a getter inside the same class leads to unnecessary computational effort. Therefore, the execution time and energy consumption of your application may also increase", (Category)ISSUE_CATEGORY, (int)5, (Severity)ISSUE_SEVERITY, (Implementation)IMPLEMENTATION);
    private static HashMap<File, Set<String>> getters = new HashMap();

    private void debugGetters() {
        for (Map.Entry<File, Set<String>> entry : getters.entrySet()) {
            System.out.println(entry.getKey().getName());
            for (String s : entry.getValue()) {
                System.out.println("\t" + s);
            }
        }
    }

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Arrays.asList(PsiMethod.class, PsiMethodCallExpression.class);
    }

    public void afterCheckProject(Context context) {
        if (context.getDriver().getPhase() == 1) {
            context.getDriver().requestRepeat((Detector)this, DETECTOR_SCOPE);
        }
        super.afterCheckProject(context);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            return new MethodChecker(context, phase);
        }
        return new CallChecker(context, phase);
    }

    private static class CallChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;

        public CallChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.phase != 1) {
                String qualifiedName;
                Set getterMethods;
                File file = this.mContext.getLocation((PsiElement)expression).getFile();
                if (getters.containsKey(file) && (getterMethods = (Set)getters.get(file)).contains(qualifiedName = expression.getMethodExpression().getQualifiedName().replace("this.", ""))) {
                    Reporter.reportIssue(this.mContext, ISSUE, (PsiExpression)expression);
                }
            }
            super.visitMethodCallExpression(expression);
        }
    }

    private static class MethodChecker
    extends JavaElementVisitor {
        private final String mReturnClass = "com.intellij.psi.impl.source.tree.java.PsiReturnStatementImpl";
        private final String mReferenceClass = "com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl";
        private final JavaContext mContext;
        private int phase;

        public MethodChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
        }

        public void visitMethod(PsiMethod method) {
            if (this.phase == 1 && this.isGetter(method)) {
                File file = this.mContext.getLocation((PsiElement)method).getFile();
                String methodName = method.getName();
                if (getters.containsKey(file)) {
                    ((Set)getters.get(file)).add(methodName);
                } else {
                    HashSet<String> methodsSet = new HashSet<String>();
                    methodsSet.add(methodName);
                    getters.put(file, methodsSet);
                }
            }
            super.visitMethod(method);
        }

        private boolean isGetter(PsiMethod method) {
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements != null) {
                PsiReturnStatement statement;
                if (statements.length != 1) {
                    return false;
                }
                if (statements[0].getClass().getTypeName().equals(this.mReturnClass) && (statement = (PsiReturnStatement)statements[0]).getReturnValue().getClass().getTypeName().equals(this.mReferenceClass)) {
                    return true;
                }
            }
            return false;
        }
    }
}

