/*
 * Decompiled with CFR 0.152.
 */
package greenlab.org.ebugslocator.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import greenlab.org.ebugslocator.utils.Reporter;
import greenlab.org.ebugslocator.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExcessiveCallsDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Class<? extends Detector> DETECTOR_CLASS = ExcessiveCallsDetector.class;
    private static final EnumSet<Scope> DETECTOR_SCOPE = Scope.JAVA_FILE_SCOPE;
    private static final Implementation IMPLEMENTATION = new Implementation(DETECTOR_CLASS, DETECTOR_SCOPE);
    private static final String ISSUE_ID = "ExcessiveMethodCalls";
    private static final String ISSUE_DESCRIPTION = "Number of method calls can be reduced";
    private static final String ISSUE_EXPLANATION = "Calling methods inside loops, either in the loop condition or in the body, is usually a good optimization target.";
    private static final Category ISSUE_CATEGORY = Category.PERFORMANCE;
    private static final int ISSUE_PRIORITY = 5;
    private static final Severity ISSUE_SEVERITY = Severity.WARNING;
    public static final Issue ISSUE = Issue.create((String)"ExcessiveMethodCalls", (String)"Number of method calls can be reduced", (String)"Calling methods inside loops, either in the loop condition or in the body, is usually a good optimization target.", (Category)ISSUE_CATEGORY, (int)5, (Severity)ISSUE_SEVERITY, (Implementation)IMPLEMENTATION);
    private Map<String, List<String>> methodCalls = new HashMap<String, List<String>>();
    private Map<String, Set<String>> conditionedVars = new HashMap<String, Set<String>>();
    private Set<String> classVars = new HashSet<String>();
    private String visitingMethod = "";

    private String getVarFromExpression(PsiMethodCallExpression expression) {
        String qualifiedName = expression.getMethodExpression().getQualifiedName().replace("this", "");
        if (qualifiedName.contains(".")) {
            String varName = qualifiedName.split("\\.")[0];
            if (this.classVars.contains(varName)) {
                return "this";
            }
            return varName;
        }
        return "this";
    }

    private String getVarFromExpression(PsiReferenceExpression expression) {
        String qualifiedName = expression.getQualifiedName();
        if (qualifiedName.startsWith("this.") || this.classVars.contains(qualifiedName)) {
            return "this";
        }
        if (qualifiedName.contains(".")) {
            return qualifiedName.split("\\.")[0];
        }
        return qualifiedName;
    }

    private String getVarFromExpression(PsiExpression expression) {
        return "";
    }

    private String expressionTag(JavaContext context, PsiMethodCallExpression expression) {
        Location l = context.getLocation((PsiElement)expression);
        String start = "(" + l.getStart().getLine() + "," + l.getStart().getColumn() + ")";
        String end = "(" + l.getEnd().getLine() + "," + l.getEnd().getColumn() + ")";
        return "[" + start + "-" + end + "]" + expression.getText();
    }

    private void debug() {
        System.out.println("{ VARS }");
        for (String method : this.conditionedVars.keySet()) {
            Set<String> set = this.conditionedVars.get(method);
            System.out.println("\t [ " + method + " ]");
            for (String var : set) {
                System.out.println("\t\t>> " + var);
            }
        }
        System.out.println("{ CALLS }");
        for (String method : this.methodCalls.keySet()) {
            List<String> list = this.methodCalls.get(method);
            System.out.println("\t [ " + method + " ]");
            for (String exp : list) {
                System.out.println("\t\t>> " + exp);
            }
        }
        System.out.println("\n\n");
    }

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Arrays.asList(PsiForStatement.class, PsiWhileStatement.class, PsiDoWhileStatement.class, PsiMethod.class, PsiMethodCallExpression.class, PsiField.class);
    }

    public void afterCheckProject(Context context) {
        if (context.getDriver().getPhase() < 3) {
            context.getDriver().requestRepeat((Detector)this, DETECTOR_SCOPE);
        }
        super.afterCheckProject(context);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            return new ClassVarsChecker(context, phase);
        }
        if (phase == 2) {
            return new LoopChecker(context, phase);
        }
        return new MethodCallChecker(context, phase);
    }

    private class MethodCallChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;
        private List<String> methodArgs;
        private List<String> debugFiles = new ArrayList<String>();
        private boolean lock;

        public MethodCallChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
            this.debugFiles.add("Debug.java");
            this.methodArgs = new ArrayList<String>();
            this.lock = false;
        }

        private boolean argsConditioned() {
            for (String arg : this.methodArgs) {
                if (arg.equals("")) {
                    return true;
                }
                if (!((Set)ExcessiveCallsDetector.this.conditionedVars.get(ExcessiveCallsDetector.this.visitingMethod)).contains(arg)) continue;
                return true;
            }
            return false;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.phase == 3) {
                if (!this.lock) {
                    this.lock = true;
                    String name = ExcessiveCallsDetector.this.getVarFromExpression(expression);
                    List calls = (List)ExcessiveCallsDetector.this.methodCalls.get(ExcessiveCallsDetector.this.visitingMethod);
                    if (calls != null && calls.contains(ExcessiveCallsDetector.this.expressionTag(this.mContext, expression))) {
                        Set vars = (Set)ExcessiveCallsDetector.this.conditionedVars.get(ExcessiveCallsDetector.this.visitingMethod);
                        for (PsiExpression e : expression.getArgumentList().getExpressions()) {
                            e.accept((PsiElementVisitor)this);
                        }
                        if (vars != null && !vars.contains(name) && !this.argsConditioned()) {
                            Reporter.reportIssue(this.mContext, ISSUE, (PsiExpression)expression);
                        }
                    }
                    this.lock = false;
                } else {
                    this.methodArgs.add(ExcessiveCallsDetector.this.getVarFromExpression(expression));
                }
            }
            this.methodArgs.clear();
            super.visitMethodCallExpression(expression);
        }

        public void visitMethod(PsiMethod method) {
            String fileName = StringUtils.getShortFileName(this.mContext.getJavaFile());
            String packageName = this.mContext.getJavaFile().getPackageName();
            ExcessiveCallsDetector.this.visitingMethod = packageName + "." + fileName + "." + method.getName();
            super.visitMethod(method);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.methodArgs.add(ExcessiveCallsDetector.this.getVarFromExpression(expression));
            super.visitReferenceExpression(expression);
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            this.methodArgs.add(ExcessiveCallsDetector.this.getVarFromExpression((PsiExpression)expression));
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            this.methodArgs.add(ExcessiveCallsDetector.this.getVarFromExpression((PsiExpression)expression));
        }
    }

    private class ClassVarsChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;

        public ClassVarsChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
        }

        public void visitField(PsiField field) {
            ExcessiveCallsDetector.this.classVars.add(field.getName());
            super.visitVariable((PsiVariable)field);
        }
    }

    private class LoopChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private int phase;
        private boolean insideLoop;
        private boolean insideAssignmentLO;
        private boolean insideAssignmentRO;
        private boolean insideLoopCondition;
        private boolean insideLoopUpdate;

        public LoopChecker(JavaContext context, int phase) {
            this.mContext = context;
            this.phase = phase;
            this.insideLoop = false;
            this.insideAssignmentLO = false;
            this.insideAssignmentRO = false;
            this.insideLoopCondition = false;
            this.insideLoopUpdate = false;
        }

        private void addConditionedVar(String varName) {
            if (ExcessiveCallsDetector.this.conditionedVars.containsKey(ExcessiveCallsDetector.this.visitingMethod)) {
                ((Set)ExcessiveCallsDetector.this.conditionedVars.get(ExcessiveCallsDetector.this.visitingMethod)).add(varName);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(varName);
                ExcessiveCallsDetector.this.conditionedVars.put(ExcessiveCallsDetector.this.visitingMethod, set);
            }
        }

        private void addMethodCall(PsiMethodCallExpression expression) {
            if (ExcessiveCallsDetector.this.methodCalls.containsKey(ExcessiveCallsDetector.this.visitingMethod)) {
                ((List)ExcessiveCallsDetector.this.methodCalls.get(ExcessiveCallsDetector.this.visitingMethod)).add(ExcessiveCallsDetector.this.expressionTag(this.mContext, expression));
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(ExcessiveCallsDetector.this.expressionTag(this.mContext, expression));
                ExcessiveCallsDetector.this.methodCalls.put(ExcessiveCallsDetector.this.visitingMethod, list);
            }
        }

        public void visitForStatement(PsiForStatement statement) {
            this.insideLoop = true;
            this.insideLoopCondition = true;
            if (statement.getCondition() != null) {
                statement.getCondition().accept((PsiElementVisitor)this);
            }
            this.insideLoopCondition = false;
            this.insideLoopUpdate = true;
            if (statement.getUpdate() != null) {
                statement.getUpdate().accept((PsiElementVisitor)this);
            }
            this.insideLoopUpdate = false;
            if (statement.getBody() != null) {
                statement.getBody().accept((PsiElementVisitor)this);
            }
            this.insideLoop = false;
            super.visitForStatement(statement);
        }

        public void visitIfStatement(PsiIfStatement statement) {
            statement.getCondition().accept((PsiElementVisitor)this);
            statement.getThenBranch().accept((PsiElementVisitor)this);
            if (statement.getElseBranch() != null) {
                statement.getElseBranch().accept((PsiElementVisitor)this);
            }
            super.visitIfStatement(statement);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.insideAssignmentLO = true;
            expression.getLExpression().accept((PsiElementVisitor)this);
            this.insideAssignmentLO = false;
            this.insideAssignmentRO = true;
            expression.getRExpression().accept((PsiElementVisitor)this);
            this.insideAssignmentRO = false;
            super.visitAssignmentExpression(expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.phase < 3 && this.insideLoop) {
                String varName = ExcessiveCallsDetector.this.getVarFromExpression(expression);
                this.addMethodCall(expression);
                if (!this.insideLoopCondition && (!this.insideAssignmentRO && !this.insideAssignmentLO || this.insideAssignmentLO)) {
                    this.addConditionedVar(varName);
                }
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.insideAssignmentLO || this.insideLoopUpdate) {
                String varName = ExcessiveCallsDetector.this.getVarFromExpression(expression);
                this.addConditionedVar(varName);
            }
            super.visitReferenceExpression(expression);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.insideLoop = true;
            statement.getCondition().accept((PsiElementVisitor)this);
            statement.getBody().accept((PsiElementVisitor)this);
            this.insideLoop = false;
            super.visitWhileStatement(statement);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.insideLoop = true;
            statement.getCondition().accept((PsiElementVisitor)this);
            statement.getBody().accept((PsiElementVisitor)this);
            this.insideLoop = false;
            super.visitDoWhileStatement(statement);
        }

        public void visitMethod(PsiMethod method) {
            String fileName = StringUtils.getShortFileName(this.mContext.getJavaFile());
            String packageName = this.mContext.getJavaFile().getPackageName();
            ExcessiveCallsDetector.this.visitingMethod = packageName + "." + fileName + "." + method.getName();
            super.visitMethod(method);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            expression.getExpression().accept((PsiElementVisitor)this);
            super.visitParenthesizedExpression(expression);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            expression.getOperand().accept((PsiElementVisitor)this);
            super.visitPostfixExpression(expression);
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            expression.getLOperand().accept((PsiElementVisitor)this);
            expression.getROperand().accept((PsiElementVisitor)this);
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            statement.getExpression().accept((PsiElementVisitor)this);
            super.visitExpressionStatement(statement);
        }

        public void visitBlockStatement(PsiBlockStatement statement) {
            for (PsiStatement s : statement.getCodeBlock().getStatements()) {
                s.accept((PsiElementVisitor)this);
            }
            super.visitBlockStatement(statement);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            if (variable.getInitializer() != null) {
                this.addConditionedVar(variable.getName());
            }
            super.visitLocalVariable(variable);
        }

        public void visitImplicitVariable(ImplicitVariable variable) {
            this.addConditionedVar(variable.getName());
            super.visitImplicitVariable(variable);
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            for (PsiElement e : statement.getDeclaredElements()) {
                e.accept((PsiElementVisitor)this);
            }
            super.visitDeclarationStatement(statement);
        }
    }
}

