/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.VideocatRecordingException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import androidx.test.tools.crawler.launcher.util.AdbExecutor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;

public class VideocatRecorder
extends Thread {
    private static final String DEVICE_TEMP_DIR = "/data/local/tmp";
    private final AdbExecutor adbExecutor;
    private final CrawlSetup crawlSetup;
    private final String appPackageName;
    private final int deviceApiLevel;

    VideocatRecorder(AdbExecutor adbExecutor, CrawlSetup crawlSetup, String appPackageName, int deviceApiLevel) {
        this.adbExecutor = adbExecutor;
        this.crawlSetup = crawlSetup;
        this.appPackageName = appPackageName;
        this.deviceApiLevel = deviceApiLevel;
    }

    @Override
    public void run() {
        Optional<File> videocatBinary = this.crawlSetup.getVideocatBinary(this.deviceApiLevel);
        if (videocatBinary.isPresent()) {
            this.adbExecutor.execute("push", videocatBinary.get().getAbsolutePath(), DEVICE_TEMP_DIR);
            byte[] videocat = this.adbExecutor.execute("shell", "/data/local/tmp/" + videocatBinary.get().getName(), "-f", "mpegts");
            Path rawVideocatOutputPath = this.crawlSetup.getOutputDirectoryPath().resolve("raw_video");
            Logger.atInfo().log("Writing raw videocat to %s", rawVideocatOutputPath.toAbsolutePath());
            try {
                Files.write(rawVideocatOutputPath, videocat, new OpenOption[0]);
            }
            catch (Exception e) {
                throw new VideocatRecordingException("Failed to write raw videocat to file " + rawVideocatOutputPath.toAbsolutePath(), e);
            }
            this.crawlSetup.postprocessVideocat(rawVideocatOutputPath, this.appPackageName);
        }
    }
}

