/*
 * Decompiled with CFR 0.152.
 */
package xyz.ylimit;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.logging.FileHandler;
import java.util.logging.SimpleFormatter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import xyz.ylimit.Util;

public class Config {
    public static final String PROJECT_NAME = "androcov";
    public static String inputAPK = "";
    public static String outputDir = "output";
    public static String forceAndroidJarPath = "";
    private static PrintStream resultPs;

    public static boolean parseArgs(String[] args) {
        Options options = new Options();
        Option output_opt = Option.builder("o").argName("directory").required().longOpt("output").hasArg().desc("path to output dir").build();
        Option input_opt = Option.builder("i").argName("APK").required().longOpt("input").hasArg().desc("path to target APK").build();
        Option sdk_opt = Option.builder("sdk").argName("android.jar").required().longOpt("android_jar").hasArg().desc("path to android.jar").build();
        Option help_opt = Option.builder("h").desc("print this help message").longOpt("help").build();
        options.addOption(output_opt);
        options.addOption(input_opt);
        options.addOption(sdk_opt);
        options.addOption(help_opt);
        DefaultParser parser2 = new DefaultParser();
        try {
            File androidJarFile;
            File codeDirFile;
            CommandLine cmd = parser2.parse(options, args);
            if (cmd.hasOption("i") && !(codeDirFile = new File(inputAPK = cmd.getOptionValue('i'))).exists()) {
                throw new ParseException("Target APK does not exist.");
            }
            if (cmd.hasOption('o')) {
                outputDir = cmd.getOptionValue('o');
                File workingDir = new File(outputDir);
                outputDir = workingDir.getPath();
                if (!workingDir.exists() && !workingDir.mkdirs()) {
                    throw new ParseException("Error generating output directory.");
                }
            }
            if (cmd.hasOption("sdk") && !(androidJarFile = new File(forceAndroidJarPath = cmd.getOptionValue("sdk"))).exists()) {
                throw new ParseException("android.jar does not exist.");
            }
            if (cmd.hasOption("h")) {
                throw new ParseException("print help message.");
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.setOptionComparator(new Comparator<Option>(){

                @Override
                public int compare(Option o1, Option o2) {
                    return o1.getOpt().length() - o2.getOpt().length();
                }
            });
            formatter.printHelp(PROJECT_NAME, options, true);
            return false;
        }
        File logFile = new File(String.format("%s/androcov.log", outputDir));
        try {
            FileHandler fh = new FileHandler(logFile.getAbsolutePath());
            fh.setFormatter(new SimpleFormatter());
            Util.LOGGER.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Util.LOGGER.info("finish parsing arguments");
        Util.LOGGER.info(String.format("[inputAPK]%s, [outputDir]%s", inputAPK, outputDir));
        return true;
    }
}

