/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

class SimpleLiveLocalsAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet<Local>> {
    FlowSet<Local> emptySet;
    Map<Unit, FlowSet<Local>> unitToGenerateSet;
    Map<Unit, FlowSet<Local>> unitToKillSet;

    SimpleLiveLocalsAnalysis(UnitGraph g) {
        super(g);
        if (Options.v().time()) {
            Timers.v().liveSetupTimer.start();
        }
        this.emptySet = new ArraySparseSet<Local>();
        this.unitToKillSet = new HashMap<Unit, FlowSet<Local>>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            FlowSet<Local> killSet = this.emptySet.clone();
            for (ValueBox box : s.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                killSet.add((Local)box.getValue(), killSet);
            }
            this.unitToKillSet.put(s, killSet);
        }
        this.unitToGenerateSet = new HashMap<Unit, FlowSet<Local>>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            FlowSet<Local> genSet = this.emptySet.clone();
            for (ValueBox box : s.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                genSet.add((Local)box.getValue(), genSet);
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        if (Options.v().time()) {
            Timers.v().liveSetupTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.start();
        }
        this.doAnalysis();
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.end();
        }
    }

    @Override
    protected FlowSet<Local> newInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected FlowSet<Local> entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(FlowSet<Local> inValue, Unit unit, FlowSet<Local> outValue) {
        inValue.difference(this.unitToKillSet.get(unit), outValue);
        outValue.union(this.unitToGenerateSet.get(unit), outValue);
    }

    @Override
    protected void merge(FlowSet<Local> in1, FlowSet<Local> in2, FlowSet<Local> out) {
        in1.union(in2, out);
    }

    @Override
    protected void copy(FlowSet<Local> source, FlowSet<Local> dest) {
        source.copy(dest);
    }
}

