/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.DivExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.RemExpr;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.SmartLocalDefsPool;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DeadAssignmentEliminator
extends BodyTransformer {
    public DeadAssignmentEliminator(Singletons.Global g) {
    }

    public static DeadAssignmentEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_DeadAssignmentEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        boolean eliminateOnlyStackLocals = PhaseOptions.getBoolean(options, "only-stack-locals");
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "] Eliminating dead code...");
        }
        if (Options.v().time()) {
            Timers.v().deadCodeTimer.start();
        }
        PatchingChain<Unit> units = b.getUnits();
        ArrayDeque<Unit> q = new ArrayDeque<Unit>(units.size());
        boolean isStatic = b.getMethod().isStatic();
        boolean allEssential = true;
        boolean checkInvoke = false;
        Local thisLocal = null;
        Iterator it = units.iterator();
        while (it.hasNext()) {
            Unit s = (Unit)it.next();
            boolean isEssential = true;
            if (s instanceof NopStmt) {
                boolean keepNop = false;
                if (b.getUnits().getLast() == s) {
                    for (Trap t : b.getTraps()) {
                        if (t.getEndUnit() != s) continue;
                        keepNop = true;
                    }
                }
                if (!keepNop) {
                    it.remove();
                    continue;
                }
            } else if (s instanceof AssignStmt) {
                Value rhs;
                AssignStmt as = (AssignStmt)s;
                Value lhs = as.getLeftOp();
                if (lhs == (rhs = as.getRightOp()) && lhs instanceof Local) {
                    it.remove();
                    continue;
                }
                if (lhs instanceof Local && (!eliminateOnlyStackLocals || ((Local)lhs).getName().startsWith("$") || lhs.getType() instanceof NullType)) {
                    isEssential = false;
                    if (!checkInvoke) {
                        checkInvoke |= as.containsInvokeExpr();
                    }
                    if (rhs instanceof CastExpr) {
                        CastExpr ce = (CastExpr)rhs;
                        if (!(ce.getCastType() instanceof RefType) || ce.getOp() != NullConstant.v()) {
                            isEssential = true;
                        }
                    } else if (rhs instanceof InvokeExpr || rhs instanceof ArrayRef || rhs instanceof NewExpr || rhs instanceof NewArrayExpr || rhs instanceof NewMultiArrayExpr) {
                        isEssential = true;
                    } else if (rhs instanceof FieldRef) {
                        isEssential = true;
                        if (rhs instanceof InstanceFieldRef) {
                            InstanceFieldRef ifr = (InstanceFieldRef)rhs;
                            if (!isStatic && thisLocal == null) {
                                thisLocal = b.getThisLocal();
                            }
                            isEssential = isStatic || thisLocal != ifr.getBase();
                        }
                    } else if (rhs instanceof DivExpr || rhs instanceof RemExpr) {
                        BinopExpr expr = (BinopExpr)rhs;
                        Type t1 = expr.getOp1().getType();
                        Type t2 = expr.getOp2().getType();
                        boolean bl = isEssential = IntType.v().equals(t1) || LongType.v().equals(t1) || IntType.v().equals(t2) || LongType.v().equals(t2);
                    }
                }
            }
            if (isEssential) {
                q.addFirst(s);
            }
            allEssential &= isEssential;
        }
        if (checkInvoke || !allEssential) {
            SmartLocalDefs localDefs = SmartLocalDefsPool.v().getSmartLocalDefsFor(b);
            UnitGraph graph = localDefs.getGraph();
            SimpleLocalUses localUses = new SimpleLocalUses(graph, (LocalDefs)localDefs);
            if (!allEssential) {
                HashSet<Unit> essential = new HashSet<Unit>(graph.size());
                while (!q.isEmpty()) {
                    Unit s = (Unit)q.removeFirst();
                    if (!essential.add(s)) continue;
                    for (ValueBox box : s.getUseBoxes()) {
                        Local l;
                        List<Unit> defs;
                        Value v = box.getValue();
                        if (!(v instanceof Local) || (defs = localDefs.getDefsOfAt(l = (Local)v, s)) == null) continue;
                        q.addAll(defs);
                    }
                }
                units.retainAll(essential);
            }
            if (checkInvoke) {
                ArrayList<AssignStmt> postProcess = new ArrayList<AssignStmt>();
                for (Unit u : units) {
                    AssignStmt s;
                    if (!(u instanceof AssignStmt) || !(s = (AssignStmt)u).containsInvokeExpr()) continue;
                    boolean deadAssignment = true;
                    for (UnitValueBoxPair pair : localUses.getUsesOf(s)) {
                        if (!units.contains(pair.unit)) continue;
                        deadAssignment = false;
                        break;
                    }
                    if (!deadAssignment) continue;
                    postProcess.add(s);
                }
                for (AssignStmt s : postProcess) {
                    InvokeStmt newInvoke = Jimple.v().newInvokeStmt(s.getInvokeExpr());
                    newInvoke.addAllTagsOf(s);
                    units.swapWith(s, newInvoke);
                    if (!Scene.v().hasCallGraph()) continue;
                    Scene.v().getCallGraph().swapEdgesOutOf(s, newInvoke);
                }
            }
        }
        if (Options.v().time()) {
            Timers.v().deadCodeTimer.end();
        }
    }
}

