/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.qualifiers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.MethodOrMethodContext;
import soot.MethodToContexts;
import soot.Modifier;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.tagkit.ColorTag;
import soot.tagkit.StringTag;

public class TightestQualifiersTagger
extends SceneTransformer {
    public static final int RESULT_PUBLIC = 0;
    public static final int RESULT_PACKAGE = 1;
    public static final int RESULT_PROTECTED = 2;
    public static final int RESULT_PRIVATE = 3;
    private final HashMap<SootMethod, Integer> methodResultsMap = new HashMap();
    private final HashMap<SootField, Integer> fieldResultsMap = new HashMap();
    private MethodToContexts methodToContexts;

    public TightestQualifiersTagger(Singletons.Global g) {
    }

    public static TightestQualifiersTagger v() {
        return G.v().soot_jimple_toolkits_annotation_qualifiers_TightestQualifiersTagger();
    }

    protected void internalTransform(String phaseName, Map options) {
        this.handleMethods();
        this.handleFields();
    }

    private void handleMethods() {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootMethod sm : appClass.getMethods()) {
                if (!Scene.v().getReachableMethods().contains(sm)) continue;
                this.analyzeMethod(sm);
            }
        }
        for (SootMethod meth : this.methodResultsMap.keySet()) {
            int result = this.methodResultsMap.get(meth);
            String sRes = "Public";
            if (result == 0) {
                sRes = "Public";
            } else if (result == 2) {
                sRes = "Protected";
            } else if (result == 1) {
                sRes = "Package";
            } else if (result == 3) {
                sRes = "Private";
            }
            String actual = null;
            actual = Modifier.isPublic(meth.getModifiers()) ? "Public" : (Modifier.isProtected(meth.getModifiers()) ? "Protected" : (Modifier.isPrivate(meth.getModifiers()) ? "Private" : "Package"));
            if (sRes.equals(actual)) continue;
            if (meth.getName().equals("<init>")) {
                meth.addTag(new StringTag("Constructor: " + meth.getDeclaringClass().getName() + " has " + actual + " level access, can have: " + sRes + " level access.", "Tightest Qualifiers"));
            } else {
                meth.addTag(new StringTag("Method: " + meth.getName() + " has " + actual + " level access, can have: " + sRes + " level access.", "Tightest Qualifiers"));
            }
            meth.addTag(new ColorTag(255, 10, 0, true, "Tightest Qualifiers"));
        }
    }

    private void analyzeMethod(SootMethod sm) {
        CallGraph cg = Scene.v().getCallGraph();
        if (this.methodToContexts == null) {
            this.methodToContexts = new MethodToContexts(Scene.v().getReachableMethods().listener());
        }
        for (MethodOrMethodContext momc : this.methodToContexts.get(sm)) {
            Iterator<Edge> callerEdges = cg.edgesInto(momc);
            while (callerEdges.hasNext()) {
                Edge callEdge = callerEdges.next();
                if (!callEdge.isExplicit()) continue;
                SootMethod methodCaller = callEdge.src();
                SootClass callingClass = methodCaller.getDeclaringClass();
                if (Modifier.isPublic(sm.getModifiers())) {
                    this.analyzePublicMethod(sm, callingClass);
                    continue;
                }
                if (Modifier.isProtected(sm.getModifiers())) {
                    this.analyzeProtectedMethod(sm, callingClass);
                    continue;
                }
                if (Modifier.isPrivate(sm.getModifiers())) continue;
                this.analyzePackageMethod(sm, callingClass);
            }
        }
    }

    private boolean analyzeProtectedMethod(SootMethod sm, SootClass callingClass) {
        SootClass methodClass = sm.getDeclaringClass();
        boolean insidePackageAccess = this.isCallSamePackage(callingClass, methodClass);
        boolean subClassAccess = this.isCallClassSubClass(callingClass, methodClass);
        boolean sameClassAccess = this.isCallClassMethodClass(callingClass, methodClass);
        if (!insidePackageAccess && subClassAccess) {
            this.methodResultsMap.put(sm, new Integer(2));
            return true;
        }
        if (insidePackageAccess && !sameClassAccess) {
            this.updateToPackage(sm);
            return false;
        }
        this.updateToPrivate(sm);
        return false;
    }

    private boolean analyzePackageMethod(SootMethod sm, SootClass callingClass) {
        SootClass methodClass = sm.getDeclaringClass();
        boolean insidePackageAccess = this.isCallSamePackage(callingClass, methodClass);
        boolean subClassAccess = this.isCallClassSubClass(callingClass, methodClass);
        boolean sameClassAccess = this.isCallClassMethodClass(callingClass, methodClass);
        if (insidePackageAccess && !sameClassAccess) {
            this.updateToPackage(sm);
            return true;
        }
        this.updateToPrivate(sm);
        return false;
    }

    private boolean analyzePublicMethod(SootMethod sm, SootClass callingClass) {
        SootClass methodClass = sm.getDeclaringClass();
        boolean insidePackageAccess = this.isCallSamePackage(callingClass, methodClass);
        boolean subClassAccess = this.isCallClassSubClass(callingClass, methodClass);
        boolean sameClassAccess = this.isCallClassMethodClass(callingClass, methodClass);
        if (!insidePackageAccess && !subClassAccess) {
            this.methodResultsMap.put(sm, new Integer(0));
            return true;
        }
        if (!insidePackageAccess && subClassAccess) {
            this.updateToProtected(sm);
            return false;
        }
        if (insidePackageAccess && !sameClassAccess) {
            this.updateToPackage(sm);
            return false;
        }
        this.updateToPrivate(sm);
        return false;
    }

    private void updateToProtected(SootMethod sm) {
        if (!this.methodResultsMap.containsKey(sm)) {
            this.methodResultsMap.put(sm, new Integer(2));
        } else if (this.methodResultsMap.get(sm) != 0) {
            this.methodResultsMap.put(sm, new Integer(2));
        }
    }

    private void updateToPackage(SootMethod sm) {
        if (!this.methodResultsMap.containsKey(sm)) {
            this.methodResultsMap.put(sm, new Integer(1));
        } else if (this.methodResultsMap.get(sm) == 3) {
            this.methodResultsMap.put(sm, new Integer(1));
        }
    }

    private void updateToPrivate(SootMethod sm) {
        if (!this.methodResultsMap.containsKey(sm)) {
            this.methodResultsMap.put(sm, new Integer(3));
        }
    }

    private boolean isCallClassMethodClass(SootClass call, SootClass check) {
        return call.equals(check);
    }

    private boolean isCallClassSubClass(SootClass call, SootClass check) {
        if (!call.hasSuperclass()) {
            return false;
        }
        return call.getSuperclass().equals(check);
    }

    private boolean isCallSamePackage(SootClass call, SootClass check) {
        return call.getPackageName().equals(check.getPackageName());
    }

    private void handleFields() {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootField sf : appClass.getFields()) {
                this.analyzeField(sf);
            }
        }
        for (SootField f : this.fieldResultsMap.keySet()) {
            int result = this.fieldResultsMap.get(f);
            String sRes = "Public";
            if (result == 0) {
                sRes = "Public";
            } else if (result == 2) {
                sRes = "Protected";
            } else if (result == 1) {
                sRes = "Package";
            } else if (result == 3) {
                sRes = "Private";
            }
            String actual = null;
            actual = Modifier.isPublic(f.getModifiers()) ? "Public" : (Modifier.isProtected(f.getModifiers()) ? "Protected" : (Modifier.isPrivate(f.getModifiers()) ? "Private" : "Package"));
            if (sRes.equals(actual)) continue;
            f.addTag(new StringTag("Field: " + f.getName() + " has " + actual + " level access, can have: " + sRes + " level access.", "Tightest Qualifiers"));
            f.addTag(new ColorTag(255, 10, 0, true, "Tightest Qualifiers"));
        }
    }

    private void analyzeField(SootField sf) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootMethod sm : appClass.getMethods()) {
                if (!sm.hasActiveBody() || !Scene.v().getReachableMethods().contains(sm)) continue;
                Body b = sm.getActiveBody();
                for (ValueBox vBox : b.getUseBoxes()) {
                    FieldRef fieldRef;
                    SootField f;
                    Value v = vBox.getValue();
                    if (!(v instanceof FieldRef) || !(f = (fieldRef = (FieldRef)v).getField()).equals(sf)) continue;
                    if (Modifier.isPublic(sf.getModifiers())) {
                        if (!this.analyzePublicField(sf, appClass)) continue;
                        return;
                    }
                    if (Modifier.isProtected(sf.getModifiers())) {
                        this.analyzeProtectedField(sf, appClass);
                        continue;
                    }
                    if (Modifier.isPrivate(sf.getModifiers())) continue;
                    this.analyzePackageField(sf, appClass);
                }
            }
        }
    }

    private boolean analyzePublicField(SootField sf, SootClass callingClass) {
        SootClass fieldClass = sf.getDeclaringClass();
        boolean insidePackageAccess = this.isCallSamePackage(callingClass, fieldClass);
        boolean subClassAccess = this.isCallClassSubClass(callingClass, fieldClass);
        boolean sameClassAccess = this.isCallClassMethodClass(callingClass, fieldClass);
        if (!insidePackageAccess && !subClassAccess) {
            this.fieldResultsMap.put(sf, new Integer(0));
            return true;
        }
        if (!insidePackageAccess && subClassAccess) {
            this.updateToProtected(sf);
            return false;
        }
        if (insidePackageAccess && !sameClassAccess) {
            this.updateToPackage(sf);
            return false;
        }
        this.updateToPrivate(sf);
        return false;
    }

    private boolean analyzeProtectedField(SootField sf, SootClass callingClass) {
        SootClass fieldClass = sf.getDeclaringClass();
        boolean insidePackageAccess = this.isCallSamePackage(callingClass, fieldClass);
        boolean subClassAccess = this.isCallClassSubClass(callingClass, fieldClass);
        boolean sameClassAccess = this.isCallClassMethodClass(callingClass, fieldClass);
        if (!insidePackageAccess && subClassAccess) {
            this.fieldResultsMap.put(sf, new Integer(2));
            return true;
        }
        if (insidePackageAccess && !sameClassAccess) {
            this.updateToPackage(sf);
            return false;
        }
        this.updateToPrivate(sf);
        return false;
    }

    private boolean analyzePackageField(SootField sf, SootClass callingClass) {
        SootClass fieldClass = sf.getDeclaringClass();
        boolean insidePackageAccess = this.isCallSamePackage(callingClass, fieldClass);
        boolean subClassAccess = this.isCallClassSubClass(callingClass, fieldClass);
        boolean sameClassAccess = this.isCallClassMethodClass(callingClass, fieldClass);
        if (insidePackageAccess && !sameClassAccess) {
            this.updateToPackage(sf);
            return true;
        }
        this.updateToPrivate(sf);
        return false;
    }

    private void updateToProtected(SootField sf) {
        if (!this.fieldResultsMap.containsKey(sf)) {
            this.fieldResultsMap.put(sf, new Integer(2));
        } else if (this.fieldResultsMap.get(sf) != 0) {
            this.fieldResultsMap.put(sf, new Integer(2));
        }
    }

    private void updateToPackage(SootField sf) {
        if (!this.fieldResultsMap.containsKey(sf)) {
            this.fieldResultsMap.put(sf, new Integer(1));
        } else if (this.fieldResultsMap.get(sf) == 3) {
            this.fieldResultsMap.put(sf, new Integer(1));
        }
    }

    private void updateToPrivate(SootField sf) {
        if (!this.fieldResultsMap.containsKey(sf)) {
            this.fieldResultsMap.put(sf, new Integer(3));
        }
    }
}

