/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import soot.Context;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.jimple.toolkits.callgraph.ContextManager;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.OnFlyCallGraphBuilder;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;

public class OnFlyCallGraph {
    private final OnFlyCallGraphBuilder ofcgb;
    private final ReachableMethods reachableMethods;
    private final QueueReader<MethodOrMethodContext> reachablesReader;
    private final QueueReader<Edge> callEdges;
    private final CallGraph callGraph;
    private PAG pag;

    public ReachableMethods reachableMethods() {
        return this.reachableMethods;
    }

    public CallGraph callGraph() {
        return this.callGraph;
    }

    public OnFlyCallGraph(PAG pag) {
        this.pag = pag;
        this.callGraph = new CallGraph();
        Scene.v().setCallGraph(this.callGraph);
        ContextManager cm = CallGraphBuilder.makeContextManager(this.callGraph);
        this.reachableMethods = Scene.v().getReachableMethods();
        this.ofcgb = new OnFlyCallGraphBuilder(cm, this.reachableMethods);
        this.reachablesReader = this.reachableMethods.listener();
        this.callEdges = cm.callGraph().listener();
    }

    public void build() {
        this.ofcgb.processReachables();
        this.processReachables();
        this.processCallEdges();
    }

    private void processReachables() {
        this.reachableMethods.update();
        while (this.reachablesReader.hasNext()) {
            MethodOrMethodContext m = this.reachablesReader.next();
            MethodPAG mpag = MethodPAG.v(this.pag, m.method());
            mpag.build();
            mpag.addToPAG(m.context());
        }
    }

    private void processCallEdges() {
        while (this.callEdges.hasNext()) {
            Edge e = this.callEdges.next();
            MethodPAG amp = MethodPAG.v(this.pag, e.tgt());
            amp.build();
            amp.addToPAG(e.tgtCtxt());
            this.pag.addCallTarget(e);
        }
    }

    public OnFlyCallGraphBuilder ofcgb() {
        return this.ofcgb;
    }

    public void updatedNode(VarNode vn) {
        Object r = vn.getVariable();
        if (!(r instanceof Local)) {
            return;
        }
        final Local receiver = (Local)r;
        final Context context = vn.context();
        PointsToSetInternal p2set = vn.getP2Set().getNewSet();
        if (this.ofcgb.wantTypes(receiver)) {
            p2set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    OnFlyCallGraph.this.ofcgb.addType(receiver, context, n.getType(), (AllocNode)n);
                }
            });
        }
        if (this.ofcgb.wantStringConstants(receiver)) {
            p2set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    if (n instanceof StringConstantNode) {
                        String constant = ((StringConstantNode)n).getString();
                        OnFlyCallGraph.this.ofcgb.addStringConstant(receiver, context, constant);
                    } else {
                        OnFlyCallGraph.this.ofcgb.addStringConstant(receiver, context, null);
                    }
                }
            });
        }
    }

    public void mergedWith(Node n1, Node n2) {
    }
}

