/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import soot.Body;
import soot.Local;
import soot.MethodSource;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;

public class PrivateFieldAccMethodSource
implements MethodSource {
    private final Type fieldType;
    private final String fieldName;
    private final boolean isStatic;
    private final SootClass classToInvoke;

    public PrivateFieldAccMethodSource(Type fieldType, String fieldName, boolean isStatic, SootClass classToInvoke) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
        this.classToInvoke = classToInvoke;
    }

    @Override
    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        LocalGenerator lg = new LocalGenerator(body);
        Local fieldBase = null;
        for (Type sootType : sootMethod.getParameterTypes()) {
            Local paramLocal = lg.generateLocal(sootType);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, 0);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            fieldBase = paramLocal;
        }
        Local fieldLocal = lg.generateLocal(this.fieldType);
        SootFieldRef field = Scene.v().makeFieldRef(this.classToInvoke, this.fieldName, this.fieldType, this.isStatic);
        FieldRef fieldRef = null;
        fieldRef = this.isStatic ? Jimple.v().newStaticFieldRef(field) : Jimple.v().newInstanceFieldRef(fieldBase, field);
        AssignStmt assign = Jimple.v().newAssignStmt(fieldLocal, fieldRef);
        body.getUnits().add(assign);
        ReturnStmt retStmt = Jimple.v().newReturnStmt(fieldLocal);
        body.getUnits().add(retStmt);
        return body;
    }
}

