/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.dexpler.DexTransformer;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;

public class DexReturnInliner
extends DexTransformer {
    public static DexReturnInliner v() {
        return new DexReturnInliner();
    }

    private boolean isInstanceofReturn(Unit u) {
        return u instanceof ReturnStmt || u instanceof ReturnVoidStmt;
    }

    private boolean isInstanceofFlowChange(Unit u) {
        return u instanceof GotoStmt || this.isInstanceofReturn(u);
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Set<Unit> duplicateIfTargets = this.getFallThroughReturns(body);
        Iterator<Unit> it = body.getUnits().snapshotIterator();
        boolean mayBeMore = false;
        do {
            mayBeMore = false;
            while (it.hasNext()) {
                IfStmt ifstmt;
                Stmt t;
                Unit u = it.next();
                if (u instanceof GotoStmt) {
                    GotoStmt gtStmt = (GotoStmt)u;
                    if (!this.isInstanceofReturn(gtStmt.getTarget())) continue;
                    Stmt stmt = (Stmt)gtStmt.getTarget().clone();
                    for (Trap t2 : body.getTraps()) {
                        for (UnitBox ubox : t2.getUnitBoxes()) {
                            if (ubox.getUnit() != u) continue;
                            ubox.setUnit(stmt);
                        }
                    }
                    while (!u.getBoxesPointingToThis().isEmpty()) {
                        u.getBoxesPointingToThis().get(0).setUnit(stmt);
                    }
                    body.getUnits().swapWith(u, stmt);
                    mayBeMore = true;
                    continue;
                }
                if (!(u instanceof IfStmt) || !this.isInstanceofReturn(t = (ifstmt = (IfStmt)u).getTarget())) continue;
                if (duplicateIfTargets == null) {
                    duplicateIfTargets = new HashSet<Unit>();
                }
                if (duplicateIfTargets.add(t)) continue;
                Unit newTarget = (Unit)t.clone();
                body.getUnits().addLast(newTarget);
                ifstmt.setTarget(newTarget);
            }
        } while (mayBeMore);
    }

    private Set<Unit> getFallThroughReturns(Body body) {
        HashSet<Unit> fallThroughReturns = null;
        Unit lastUnit = null;
        for (Unit u : body.getUnits()) {
            if (lastUnit != null && this.isInstanceofReturn(u) && !this.isInstanceofFlowChange(lastUnit)) {
                if (fallThroughReturns == null) {
                    fallThroughReturns = new HashSet<Unit>();
                }
                fallThroughReturns.add(u);
            }
            lastUnit = u;
        }
        return fallThroughReturns;
    }
}

