/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.NameType;
import soot.JastAddJ.PackageAccess;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeAccess;
import soot.JastAddJ.VarAccess;

public class AmbiguousAccess
extends Access
implements Cloneable {
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;

    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public AmbiguousAccess clone() throws CloneNotSupportedException {
        AmbiguousAccess node = (AmbiguousAccess)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AmbiguousAccess copy() {
        try {
            AmbiguousAccess node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public AmbiguousAccess fullCopy() {
        AmbiguousAccess tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void nameCheck() {
        this.error("ambiguous name " + this.name());
    }

    public AmbiguousAccess(String name, int start, int end) {
        this(name);
        this.start = this.IDstart = start;
        this.end = this.IDend = end;
    }

    public AmbiguousAccess() {
    }

    @Override
    public void init$Children() {
    }

    public AmbiguousAccess(String p0) {
        this.setID(p0);
    }

    public AmbiguousAccess(Symbol p0) {
        this.setID(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleSet qualifiedLookupType(String name) {
        ASTNode$State state = this.state();
        SimpleSet simpleSet = SimpleSet.emptySet;
        return simpleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleSet qualifiedLookupVariable(String name) {
        ASTNode$State state = this.state();
        SimpleSet simpleSet = SimpleSet.emptySet;
        return simpleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        String string = this.getClass().getName() + " [" + this.getID() + "]";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String name() {
        ASTNode$State state = this.state();
        String string = this.getID();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameType predNameType() {
        ASTNode$State state = this.state();
        NameType nameType = NameType.AMBIGUOUS_NAME;
        return nameType;
    }

    @Override
    public ASTNode rewriteTo() {
        if (!this.duringSyntacticClassification()) {
            ++this.state().duringNameResolution;
            Access result = this.rewriteRule0();
            --this.state().duringNameResolution;
            return result;
        }
        return super.rewriteTo();
    }

    private Access rewriteRule0() {
        if (!this.lookupVariable(this.name()).isEmpty()) {
            return new VarAccess(this.name(), this.start(), this.end());
        }
        if (!this.lookupType(this.name()).isEmpty()) {
            return new TypeAccess(this.name(), this.start(), this.end());
        }
        return new PackageAccess(this.name(), this.start(), this.end());
    }
}

