/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.pool.BaseOffsetPool;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.dexlib2.writer.pool.FieldPool;
import org.jf.dexlib2.writer.pool.MethodPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypePool;

public class AnnotationPool
extends BaseOffsetPool<Annotation>
implements AnnotationSection<CharSequence, CharSequence, Annotation, AnnotationElement, EncodedValue> {
    @Nonnull
    StringPool stringPool;
    @Nonnull
    TypePool typePool;
    @Nonnull
    FieldPool fieldPool;
    @Nonnull
    MethodPool methodPool;

    public AnnotationPool(@Nonnull StringPool stringPool, @Nonnull TypePool typePool, @Nonnull FieldPool fieldPool, @Nonnull MethodPool methodPool) {
        this.stringPool = stringPool;
        this.typePool = typePool;
        this.fieldPool = fieldPool;
        this.methodPool = methodPool;
    }

    public void intern(@Nonnull Annotation annotation2) {
        Integer prev = this.internedItems.put(annotation2, 0);
        if (prev == null) {
            this.typePool.intern(annotation2.getType());
            for (AnnotationElement annotationElement : annotation2.getElements()) {
                this.stringPool.intern(annotationElement.getName());
                DexPool.internEncodedValue(annotationElement.getValue(), this.stringPool, this.typePool, this.fieldPool, this.methodPool);
            }
        }
    }

    @Override
    public int getVisibility(@Nonnull Annotation annotation2) {
        return annotation2.getVisibility();
    }

    @Override
    @Nonnull
    public CharSequence getType(@Nonnull Annotation annotation2) {
        return annotation2.getType();
    }

    @Override
    @Nonnull
    public Collection<? extends AnnotationElement> getElements(@Nonnull Annotation annotation2) {
        return annotation2.getElements();
    }

    @Override
    @Nonnull
    public CharSequence getElementName(@Nonnull AnnotationElement annotationElement) {
        return annotationElement.getName();
    }

    @Override
    @Nonnull
    public EncodedValue getElementValue(@Nonnull AnnotationElement annotationElement) {
        return annotationElement.getValue();
    }
}

