/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.instruction;

import javax.annotation.Nonnull;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.formats.Instruction25x;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction25x
extends ImmutableInstruction
implements Instruction25x {
    public static final Format FORMAT = Format.Format25x;
    protected final int parameterRegisterCount;
    protected final int registerClosure;
    protected final int registerD;
    protected final int registerE;
    protected final int registerF;
    protected final int registerG;

    public ImmutableInstruction25x(@Nonnull Opcode opcode, int parameterRegisterCount, int registerClosure, int registerD, int registerE, int registerF, int registerG) {
        super(opcode);
        this.parameterRegisterCount = Preconditions.check25xParameterRegisterCount(parameterRegisterCount);
        this.registerClosure = Preconditions.checkNibbleRegister(registerClosure);
        this.registerD = parameterRegisterCount > 0 ? Preconditions.checkNibbleRegister(registerD) : 0;
        this.registerE = parameterRegisterCount > 1 ? Preconditions.checkNibbleRegister(registerE) : 0;
        this.registerF = parameterRegisterCount > 2 ? Preconditions.checkNibbleRegister(registerF) : 0;
        this.registerG = parameterRegisterCount > 3 ? Preconditions.checkNibbleRegister(registerG) : 0;
    }

    public static ImmutableInstruction25x of(Instruction25x instruction) {
        if (instruction instanceof ImmutableInstruction25x) {
            return (ImmutableInstruction25x)instruction;
        }
        return new ImmutableInstruction25x(instruction.getOpcode(), instruction.getRegisterCount(), instruction.getRegisterFixedC(), instruction.getRegisterParameterD(), instruction.getRegisterParameterE(), instruction.getRegisterParameterF(), instruction.getRegisterParameterG());
    }

    @Override
    public int getParameterRegisterCount() {
        return this.parameterRegisterCount;
    }

    @Override
    public int getRegisterCount() {
        return this.parameterRegisterCount + 1;
    }

    @Override
    public int getRegisterFixedC() {
        return this.registerClosure;
    }

    @Override
    public int getRegisterParameterD() {
        return this.registerD;
    }

    @Override
    public int getRegisterParameterE() {
        return this.registerE;
    }

    @Override
    public int getRegisterParameterF() {
        return this.registerF;
    }

    @Override
    public int getRegisterParameterG() {
        return this.registerG;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

