/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.ArrayProto;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.PrimitiveProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnknownClassProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.reflection.ReflectionClassDef;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.immutable.ImmutableDexFile;
import org.jf.util.ExceptionWithContext;

public class ClassPath {
    @Nonnull
    private final TypeProto unknownClass;
    @Nonnull
    private HashMap<String, ClassDef> availableClasses = Maps.newHashMap();
    private boolean checkPackagePrivateAccess;
    private final CacheLoader<String, TypeProto> classLoader = new CacheLoader<String, TypeProto>(){

        @Override
        public TypeProto load(String type) throws Exception {
            if (type.charAt(0) == '[') {
                return new ArrayProto(ClassPath.this, type);
            }
            return new ClassProto(ClassPath.this, type);
        }
    };
    @Nonnull
    private LoadingCache<String, TypeProto> loadedClasses = CacheBuilder.newBuilder().build(this.classLoader);
    private static final Pattern dalvikCacheOdexPattern = Pattern.compile("@([^@]+)@classes.dex$");

    public ClassPath(DexFile ... classPath) throws IOException {
        this(Lists.newArrayList(classPath), 15);
    }

    public ClassPath(@Nonnull Iterable<DexFile> classPath, int api) {
        this(Lists.newArrayList(classPath), api == 17);
    }

    public ClassPath(@Nonnull Iterable<DexFile> classPath, boolean checkPackagePrivateAccess) {
        Iterable<DexFile> dexFiles = Iterables.concat(classPath, Lists.newArrayList(ClassPath.getBasicClasses()));
        this.unknownClass = new UnknownClassProto(this);
        this.loadedClasses.put(this.unknownClass.getType(), this.unknownClass);
        this.checkPackagePrivateAccess = checkPackagePrivateAccess;
        this.loadPrimitiveType("Z");
        this.loadPrimitiveType("B");
        this.loadPrimitiveType("S");
        this.loadPrimitiveType("C");
        this.loadPrimitiveType("I");
        this.loadPrimitiveType("J");
        this.loadPrimitiveType("F");
        this.loadPrimitiveType("D");
        this.loadPrimitiveType("L");
        for (DexFile dexFile : dexFiles) {
            for (ClassDef classDef : dexFile.getClasses()) {
                ClassDef prev = this.availableClasses.get(classDef.getType());
                if (prev != null) continue;
                this.availableClasses.put(classDef.getType(), classDef);
            }
        }
    }

    private void loadPrimitiveType(String type) {
        this.loadedClasses.put(type, new PrimitiveProto(this, type));
    }

    private static DexFile getBasicClasses() {
        return new ImmutableDexFile((Collection<? extends ClassDef>)ImmutableSet.of(new ReflectionClassDef(Class.class), new ReflectionClassDef(Cloneable.class), new ReflectionClassDef(Object.class), new ReflectionClassDef(Serializable.class), new ReflectionClassDef(String.class), new ReflectionClassDef(Throwable.class), new ReflectionClassDef[0]));
    }

    @Nonnull
    public TypeProto getClass(CharSequence type) {
        return this.loadedClasses.getUnchecked(type.toString());
    }

    @Nonnull
    public ClassDef getClassDef(String type) {
        ClassDef ret = this.availableClasses.get(type);
        if (ret == null) {
            throw new UnresolvedClassException("Could not resolve class %s", type);
        }
        return ret;
    }

    @Nonnull
    public TypeProto getUnknownClass() {
        return this.unknownClass;
    }

    public boolean shouldCheckPackagePrivateAccess() {
        return this.checkPackagePrivateAccess;
    }

    @Nonnull
    public static ClassPath fromClassPath(Iterable<String> classPathDirs, Iterable<String> classPath, DexFile dexFile, int api, boolean experimental) {
        return ClassPath.fromClassPath(classPathDirs, classPath, dexFile, api, api == 17, experimental);
    }

    @Nonnull
    public static ClassPath fromClassPath(Iterable<String> classPathDirs, Iterable<String> classPath, DexFile dexFile, int api, boolean checkPackagePrivateAccess, boolean experimental) {
        ArrayList<DexFile> dexFiles = Lists.newArrayList();
        for (String classPathEntry : classPath) {
            try {
                dexFiles.add(ClassPath.loadClassPathEntry(classPathDirs, classPathEntry, api, experimental));
            }
            catch (ExceptionWithContext e) {}
        }
        dexFiles.add(dexFile);
        return new ClassPath(dexFiles, checkPackagePrivateAccess);
    }

    @Nonnull
    private static DexFile loadClassPathEntry(@Nonnull Iterable<String> classPathDirs, @Nonnull String bootClassPathEntry, int api, boolean experimental) {
        int extIndex;
        File rawEntry = new File(bootClassPathEntry);
        String entryName = rawEntry.getName();
        if (entryName.endsWith("@classes.dex")) {
            Matcher m = dalvikCacheOdexPattern.matcher(entryName);
            if (!m.find()) {
                throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", bootClassPathEntry), new Object[0]);
            }
            entryName = m.group(1);
        }
        String baseEntryName = (extIndex = entryName.lastIndexOf(".")) == -1 ? entryName : entryName.substring(0, extIndex);
        for (String classPathDir : classPathDirs) {
            for (String ext : new String[]{"", ".odex", ".jar", ".apk", ".zip"}) {
                File file = new File(classPathDir, baseEntryName + ext);
                if (!file.exists() || !file.isFile()) continue;
                if (!file.canRead()) {
                    System.err.println(String.format("warning: cannot open %s for reading. Will continue looking.", file.getPath()));
                    continue;
                }
                try {
                    return DexFileFactory.loadDexFile(file, api, experimental);
                }
                catch (DexFileFactory.NoClassesDexException ex) {
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading boot class path entry \"%s\"", bootClassPathEntry);
                }
            }
        }
        throw new ExceptionWithContext("Cannot locate boot class path file %s", bootClassPathEntry);
    }
}

