"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class UniswapV3(BaseSDK):
    def uniswap_quote_buy_exactly(
        self,
        *,
        chain: models.V1UniswapQuoteBuyExactlyChain,
        token_in: str,
        token_out: str,
        fee: models.V1UniswapQuoteBuyExactlyFeeEnum,
        amount_out: Union[
            models.V1UniswapQuoteBuyExactlyAmountOut,
            models.V1UniswapQuoteBuyExactlyAmountOutTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapBuyQuoteInfoResponse:
        r"""Get Quote - to Specified Amount

        This endpoint calculates the amount of input tokens required to purchase a
        specified amount of output tokens from a Uniswap pool.

        It also provides the resulting price after the transaction. The calculation takes
        into account the current pool state and the specified fee tier.

        :param chain:
        :param token_in: The symbol or address of the token to swap from.
        :param token_out: The symbol or address of the token to swap to.
        :param fee: The fee to pay for the swap
        :param amount_out: The amount of the token to swap to
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapQuoteBuyExactlyRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_out=amount_out,
        )

        req = self._build_request(
            method="GET",
            path="/v1/uniswap/quote/buy_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_quote_buy_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UniswapBuyQuoteInfoResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_quote_buy_exactly_async(
        self,
        *,
        chain: models.V1UniswapQuoteBuyExactlyChain,
        token_in: str,
        token_out: str,
        fee: models.V1UniswapQuoteBuyExactlyFeeEnum,
        amount_out: Union[
            models.V1UniswapQuoteBuyExactlyAmountOut,
            models.V1UniswapQuoteBuyExactlyAmountOutTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapBuyQuoteInfoResponse:
        r"""Get Quote - to Specified Amount

        This endpoint calculates the amount of input tokens required to purchase a
        specified amount of output tokens from a Uniswap pool.

        It also provides the resulting price after the transaction. The calculation takes
        into account the current pool state and the specified fee tier.

        :param chain:
        :param token_in: The symbol or address of the token to swap from.
        :param token_out: The symbol or address of the token to swap to.
        :param fee: The fee to pay for the swap
        :param amount_out: The amount of the token to swap to
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapQuoteBuyExactlyRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_out=amount_out,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/uniswap/quote/buy_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_quote_buy_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UniswapBuyQuoteInfoResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_quote_sell_exactly(
        self,
        *,
        chain: models.V1UniswapQuoteSellExactlyChain,
        token_in: str,
        token_out: str,
        fee: models.V1UniswapQuoteSellExactlyFeeEnum,
        amount_in: Union[
            models.V1UniswapQuoteSellExactlyAmountIn,
            models.V1UniswapQuoteSellExactlyAmountInTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapSellQuoteInfoResponse:
        r"""Get quote - From Specified Amount

        This endpoint calculates the amount of input tokens required to purchase a
        specified amount of output tokens from a Uniswap pool.

        It also provides the resulting price after the transaction. The calculation takes
        into account the current pool state and the specified fee tier.

        :param chain:
        :param token_in: The symbol or address of the token to swap from.
        :param token_out: The symbol or address of the token to swap to.
        :param fee: The fee to pay for the swap
        :param amount_in: The amount of the token to swap from
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapQuoteSellExactlyRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_in=amount_in,
        )

        req = self._build_request(
            method="GET",
            path="/v1/uniswap/quote/sell_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_quote_sell_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapSellQuoteInfoResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_quote_sell_exactly_async(
        self,
        *,
        chain: models.V1UniswapQuoteSellExactlyChain,
        token_in: str,
        token_out: str,
        fee: models.V1UniswapQuoteSellExactlyFeeEnum,
        amount_in: Union[
            models.V1UniswapQuoteSellExactlyAmountIn,
            models.V1UniswapQuoteSellExactlyAmountInTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapSellQuoteInfoResponse:
        r"""Get quote - From Specified Amount

        This endpoint calculates the amount of input tokens required to purchase a
        specified amount of output tokens from a Uniswap pool.

        It also provides the resulting price after the transaction. The calculation takes
        into account the current pool state and the specified fee tier.

        :param chain:
        :param token_in: The symbol or address of the token to swap from.
        :param token_out: The symbol or address of the token to swap to.
        :param fee: The fee to pay for the swap
        :param amount_in: The amount of the token to swap from
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapQuoteSellExactlyRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_in=amount_in,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/uniswap/quote/sell_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_quote_sell_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapSellQuoteInfoResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_pool_price(
        self,
        *,
        chain: models.V1UniswapPoolPriceChain,
        token_in: str,
        token_out: str,
        fee: models.V1UniswapPoolPriceFeeEnum,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapPoolPriceResponse:
        r"""Pool Price

        This endpoint calculates the price of a token in a Uniswap pool.

        The price is calculated based on the current pool state and the specified fee tier.

        :param chain:
        :param token_in: The symbol or address of a token in the pool
        :param token_out: The symbol or address of a token in the pool
        :param fee: The fee of the pool
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapPoolPriceRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            fee=fee,
        )

        req = self._build_request(
            method="GET",
            path="/v1/uniswap/pool_price",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_pool_price",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UniswapPoolPriceResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_pool_price_async(
        self,
        *,
        chain: models.V1UniswapPoolPriceChain,
        token_in: str,
        token_out: str,
        fee: models.V1UniswapPoolPriceFeeEnum,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapPoolPriceResponse:
        r"""Pool Price

        This endpoint calculates the price of a token in a Uniswap pool.

        The price is calculated based on the current pool state and the specified fee tier.

        :param chain:
        :param token_in: The symbol or address of a token in the pool
        :param token_out: The symbol or address of a token in the pool
        :param fee: The fee of the pool
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapPoolPriceRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            fee=fee,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/uniswap/pool_price",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_pool_price",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UniswapPoolPriceResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_liquidity_provision_in_range(
        self,
        *,
        chain: models.V1UniswapLiquidityProvisionInRangeChain,
        token_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapCheckInRangeResponse:
        r"""Check if LP is Active.

        This endpoint allows users to check whether a specific liquidity provider ()
        position is within the active tick range on the uniswap platform.

        by providing the token id associated with the position, users can verify if the
        position is currently within the tick range where trading occurs. this information
        is essential for users to monitor the status of their lp positions and ensure that
        they are actively participating in the trading activities within the liquidity pool
        and earning trading fees.

        :param chain:
        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapLiquidityProvisionInRangeRequest(
            chain=chain,
            token_id=token_id,
        )

        req = self._build_request(
            method="GET",
            path="/v1/uniswap/liquidity_provision/in_range",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_in_range",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UniswapCheckInRangeResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_liquidity_provision_in_range_async(
        self,
        *,
        chain: models.V1UniswapLiquidityProvisionInRangeChain,
        token_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapCheckInRangeResponse:
        r"""Check if LP is Active.

        This endpoint allows users to check whether a specific liquidity provider ()
        position is within the active tick range on the uniswap platform.

        by providing the token id associated with the position, users can verify if the
        position is currently within the tick range where trading occurs. this information
        is essential for users to monitor the status of their lp positions and ensure that
        they are actively participating in the trading activities within the liquidity pool
        and earning trading fees.

        :param chain:
        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapLiquidityProvisionInRangeRequest(
            chain=chain,
            token_id=token_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/uniswap/liquidity_provision/in_range",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_in_range",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.UniswapCheckInRangeResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_liquidity_provision_positions(
        self,
        *,
        chain: models.V1UniswapLiquidityProvisionPositionsChain,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapLPPositionsInfoResponse:
        r"""List LP

        This endpoint retrieves the number of Liquidity Provider (LP) positions
        associated with a specific sender address on the Uniswap platform.

        Users can query this endpoint to obtain detailed information about their LP
        positions, including the total number of positions and relevant metadata. This
        information is crucial for users to manage and analyze their liquidity provision
        activities effectively.

        :param chain:
        :param user: The user to get positions for.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapLiquidityProvisionPositionsRequest(
            chain=chain,
            user=user,
        )

        req = self._build_request(
            method="GET",
            path="/v1/uniswap/liquidity_provision/positions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_positions",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapLPPositionsInfoResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_liquidity_provision_positions_async(
        self,
        *,
        chain: models.V1UniswapLiquidityProvisionPositionsChain,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapLPPositionsInfoResponse:
        r"""List LP

        This endpoint retrieves the number of Liquidity Provider (LP) positions
        associated with a specific sender address on the Uniswap platform.

        Users can query this endpoint to obtain detailed information about their LP
        positions, including the total number of positions and relevant metadata. This
        information is crucial for users to manage and analyze their liquidity provision
        activities effectively.

        :param chain:
        :param user: The user to get positions for.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1UniswapLiquidityProvisionPositionsRequest(
            chain=chain,
            user=user,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/uniswap/liquidity_provision/positions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_positions",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapLPPositionsInfoResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_swap_buy_exactly(
        self,
        *,
        token_in: str,
        token_out: str,
        fee: models.FeeEnum,
        amount_out: Union[
            models.UniswapBuyExactlyRequestAmountOut,
            models.UniswapBuyExactlyRequestAmountOutTypedDict,
        ],
        max_slippage_percent: float,
        chain: models.UniswapBuyExactlyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapBuyExactlyTransactionResponse:
        r"""Buy exact amount

        This endpoint allows users to trade a variable amount of one token to receive an
        exact amount of another token using the Uniswap protocol.

        The transaction is executed on the specified blockchain network, and the user must
        provide the necessary transaction details, including the token to buy, the token to
        pay with, and the exact amount to receive. If the token being paid with is ETH and
        needs to be wrapped, the appropriate amount will be wrapped automatically.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3Router`
        </Info>


        :param token_in: The symbol or address of the token to swap from..
        :param token_out: The symbol or address of the token to swap to..
        :param fee: The transaction fee of a Uniswap pool in bips.

            Uniswap supports 4 different fee levels.
        :param amount_out: The amount of 'token_out' to buy.
        :param max_slippage_percent: The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapBuyExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_out=amount_out,
            max_slippage_percent=max_slippage_percent,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/uniswap/swap/buy_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.UniswapBuyExactlyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_swap_buy_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapBuyExactlyTransactionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_swap_buy_exactly_async(
        self,
        *,
        token_in: str,
        token_out: str,
        fee: models.FeeEnum,
        amount_out: Union[
            models.UniswapBuyExactlyRequestAmountOut,
            models.UniswapBuyExactlyRequestAmountOutTypedDict,
        ],
        max_slippage_percent: float,
        chain: models.UniswapBuyExactlyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapBuyExactlyTransactionResponse:
        r"""Buy exact amount

        This endpoint allows users to trade a variable amount of one token to receive an
        exact amount of another token using the Uniswap protocol.

        The transaction is executed on the specified blockchain network, and the user must
        provide the necessary transaction details, including the token to buy, the token to
        pay with, and the exact amount to receive. If the token being paid with is ETH and
        needs to be wrapped, the appropriate amount will be wrapped automatically.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3Router`
        </Info>


        :param token_in: The symbol or address of the token to swap from..
        :param token_out: The symbol or address of the token to swap to..
        :param fee: The transaction fee of a Uniswap pool in bips.

            Uniswap supports 4 different fee levels.
        :param amount_out: The amount of 'token_out' to buy.
        :param max_slippage_percent: The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapBuyExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_out=amount_out,
            max_slippage_percent=max_slippage_percent,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/uniswap/swap/buy_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.UniswapBuyExactlyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_swap_buy_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapBuyExactlyTransactionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_swap_sell_exactly(
        self,
        *,
        token_in: str,
        token_out: str,
        fee: models.FeeEnum,
        amount_in: Union[
            models.UniswapSellExactlyRequestAmountIn,
            models.UniswapSellExactlyRequestAmountInTypedDict,
        ],
        max_slippage_percent: float,
        chain: models.UniswapSellExactlyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapSellExactlyTransactionResponse:
        r"""Sell exact amount

        This endpoint allows users to trade a specific amount of one token into another
        token using the Uniswap protocol.

        The transaction is executed on the specified blockchain network, and the user must
        provide the necessary transaction details, including the token to sell, the token to
        receive, and the amount to sell. If the token being sold is ETH and needs to be
        wrapped, the appropriate amount will be wrapped automatically.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3Router`
        </Info>


        :param token_in: The symbol or address of the token to sell..
        :param token_out: The symbol or address of the token to buy..
        :param fee: The transaction fee of a Uniswap pool in bips.

            Uniswap supports 4 different fee levels.
        :param amount_in: The amount of the `token_in` to sell
        :param max_slippage_percent: The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapSellExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_in=amount_in,
            max_slippage_percent=max_slippage_percent,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/uniswap/swap/sell_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.UniswapSellExactlyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_swap_sell_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapSellExactlyTransactionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_swap_sell_exactly_async(
        self,
        *,
        token_in: str,
        token_out: str,
        fee: models.FeeEnum,
        amount_in: Union[
            models.UniswapSellExactlyRequestAmountIn,
            models.UniswapSellExactlyRequestAmountInTypedDict,
        ],
        max_slippage_percent: float,
        chain: models.UniswapSellExactlyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.UniswapSellExactlyTransactionResponse:
        r"""Sell exact amount

        This endpoint allows users to trade a specific amount of one token into another
        token using the Uniswap protocol.

        The transaction is executed on the specified blockchain network, and the user must
        provide the necessary transaction details, including the token to sell, the token to
        receive, and the amount to sell. If the token being sold is ETH and needs to be
        wrapped, the appropriate amount will be wrapped automatically.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3Router`
        </Info>


        :param token_in: The symbol or address of the token to sell..
        :param token_out: The symbol or address of the token to buy..
        :param fee: The transaction fee of a Uniswap pool in bips.

            Uniswap supports 4 different fee levels.
        :param amount_in: The amount of the `token_in` to sell
        :param max_slippage_percent: The maximum slippage allowed in percent. e.g. `1` means `1 %` slippage allowed.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapSellExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            fee=fee,
            amount_in=amount_in,
            max_slippage_percent=max_slippage_percent,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/uniswap/swap/sell_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.UniswapSellExactlyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_swap_sell_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.UniswapSellExactlyTransactionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_liquidity_provision_mint(
        self,
        *,
        token0: str,
        token1: str,
        fee: models.FeeEnum,
        tick_lower: int,
        tick_upper: int,
        amount0_desired: Union[
            models.UniswapMintLiquidityProvisionRequestAmount0Desired,
            models.UniswapMintLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.UniswapMintLiquidityProvisionRequestAmount1Desired,
            models.UniswapMintLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.UniswapMintLiquidityProvisionRequestAmount0Min,
            models.UniswapMintLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.UniswapMintLiquidityProvisionRequestAmount1Min,
            models.UniswapMintLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.UniswapMintLiquidityProvisionRequestChain,
        sender: str,
        recipient: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Open a new LP position

        This endpoint allows users to open a new Liquidity Provider (LP) position on the
        Uniswap platform.

        By providing the necessary parameters, users can initiate a minting process to
        create a new LP token, which represents their stake in a specific liquidity pool.
        This operation is essential for users looking to participate in liquidity provision,
        enabling them to earn fees from trades that occur within the pool. The endpoint
        requires details such as the token pair, amount, and any additional parameters
        needed for the minting process.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3NFTPositionManager`
        </Info>


        :param token0: The symbol or address of the first token in the pair.
        :param token1: The symbol or address of the second token in the pair.
        :param fee: The transaction fee of a Uniswap pool in bips.

            Uniswap supports 4 different fee levels.
        :param tick_lower: The lower tick of the range to mint the position in
        :param tick_upper: The upper tick of the range to mint the position in
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param recipient: The address that will receive the LP tokens
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapMintLiquidityProvisionRequest(
            token0=token0,
            token1=token1,
            fee=fee,
            tick_lower=tick_lower,
            tick_upper=tick_upper,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            recipient=recipient,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/uniswap/liquidity_provision/mint",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.UniswapMintLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_mint",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_liquidity_provision_mint_async(
        self,
        *,
        token0: str,
        token1: str,
        fee: models.FeeEnum,
        tick_lower: int,
        tick_upper: int,
        amount0_desired: Union[
            models.UniswapMintLiquidityProvisionRequestAmount0Desired,
            models.UniswapMintLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.UniswapMintLiquidityProvisionRequestAmount1Desired,
            models.UniswapMintLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.UniswapMintLiquidityProvisionRequestAmount0Min,
            models.UniswapMintLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.UniswapMintLiquidityProvisionRequestAmount1Min,
            models.UniswapMintLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.UniswapMintLiquidityProvisionRequestChain,
        sender: str,
        recipient: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Open a new LP position

        This endpoint allows users to open a new Liquidity Provider (LP) position on the
        Uniswap platform.

        By providing the necessary parameters, users can initiate a minting process to
        create a new LP token, which represents their stake in a specific liquidity pool.
        This operation is essential for users looking to participate in liquidity provision,
        enabling them to earn fees from trades that occur within the pool. The endpoint
        requires details such as the token pair, amount, and any additional parameters
        needed for the minting process.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3NFTPositionManager`
        </Info>


        :param token0: The symbol or address of the first token in the pair.
        :param token1: The symbol or address of the second token in the pair.
        :param fee: The transaction fee of a Uniswap pool in bips.

            Uniswap supports 4 different fee levels.
        :param tick_lower: The lower tick of the range to mint the position in
        :param tick_upper: The upper tick of the range to mint the position in
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param recipient: The address that will receive the LP tokens
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapMintLiquidityProvisionRequest(
            token0=token0,
            token1=token1,
            fee=fee,
            tick_lower=tick_lower,
            tick_upper=tick_upper,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            recipient=recipient,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/uniswap/liquidity_provision/mint",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.UniswapMintLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_mint",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_liquidity_provision_increase(
        self,
        *,
        token_id: int,
        amount0_desired: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount0Desired,
            models.UniswapIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount1Desired,
            models.UniswapIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount0Min,
            models.UniswapIncreaseLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount1Min,
            models.UniswapIncreaseLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.UniswapIncreaseLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Increase an LP position

        This endpoint allows users to increase their existing Liquidity Provider (LP)
        positions on the Uniswap platform.

        By providing the necessary parameters, users can add more liquidity to their current
        positions, thereby increasing their stake in the liquidity pool. This operation is
        beneficial for users who wish to enhance their potential earnings from trading fees
        within the pool. The endpoint requires details such as the token pair, additional
        amount to be added, and any other parameters necessary for the liquidity increase
        process.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapIncreaseLiquidityProvisionRequest(
            token_id=token_id,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/uniswap/liquidity_provision/increase",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.UniswapIncreaseLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_increase",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_liquidity_provision_increase_async(
        self,
        *,
        token_id: int,
        amount0_desired: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount0Desired,
            models.UniswapIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount1Desired,
            models.UniswapIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount0Min,
            models.UniswapIncreaseLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.UniswapIncreaseLiquidityProvisionRequestAmount1Min,
            models.UniswapIncreaseLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.UniswapIncreaseLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Increase an LP position

        This endpoint allows users to increase their existing Liquidity Provider (LP)
        positions on the Uniswap platform.

        By providing the necessary parameters, users can add more liquidity to their current
        positions, thereby increasing their stake in the liquidity pool. This operation is
        beneficial for users who wish to enhance their potential earnings from trading fees
        within the pool. The endpoint requires details such as the token pair, additional
        amount to be added, and any other parameters necessary for the liquidity increase
        process.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapIncreaseLiquidityProvisionRequest(
            token_id=token_id,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/uniswap/liquidity_provision/increase",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.UniswapIncreaseLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_increase",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def uniswap_liquidity_provision_withdraw(
        self,
        *,
        token_id: int,
        percentage_for_withdrawal: Union[
            models.UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawal,
            models.UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict,
        ],
        chain: models.UniswapWithdrawLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw an LP position

        This endpoint allows users to withdraw their Liquidity Provider (LP) positions
        from the Uniswap platform.

        By specifying the necessary parameters, users can initiate the withdrawal process to
        remove their stake from a specific liquidity pool. This operation is crucial for
        users who wish to reclaim their assets or reallocate their liquidity to different
        pools or investments. The endpoint requires details such as the token pair, the
        amount to be withdrawn, and any additional parameters needed for the withdrawal
        process. Users should ensure they meet any protocol requirements or conditions
        before initiating a withdrawal to avoid potential issues or penalties.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3NFTPositionManager`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param percentage_for_withdrawal: How much liquidity to take out in percentage.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapWithdrawLiquidityProvisionRequest(
            token_id=token_id,
            percentage_for_withdrawal=percentage_for_withdrawal,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/uniswap/liquidity_provision/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.UniswapWithdrawLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def uniswap_liquidity_provision_withdraw_async(
        self,
        *,
        token_id: int,
        percentage_for_withdrawal: Union[
            models.UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawal,
            models.UniswapWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict,
        ],
        chain: models.UniswapWithdrawLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw an LP position

        This endpoint allows users to withdraw their Liquidity Provider (LP) positions
        from the Uniswap platform.

        By specifying the necessary parameters, users can initiate the withdrawal process to
        remove their stake from a specific liquidity pool. This operation is crucial for
        users who wish to reclaim their assets or reallocate their liquidity to different
        pools or investments. The endpoint requires details such as the token pair, the
        amount to be withdrawn, and any additional parameters needed for the withdrawal
        process. Users should ensure they meet any protocol requirements or conditions
        before initiating a withdrawal to avoid potential issues or penalties.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `UniswapV3NFTPositionManager`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param percentage_for_withdrawal: How much liquidity to take out in percentage.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UniswapWithdrawLiquidityProvisionRequest(
            token_id=token_id,
            percentage_for_withdrawal=percentage_for_withdrawal,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/uniswap/liquidity_provision/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.UniswapWithdrawLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_uniswap_liquidity_provision_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
