"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class TransactionBundler(BaseSDK):
    def transaction_bundler_authorization(
        self,
        *,
        chain: models.MulticallAuthorizationRequestChain,
        sender: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MulticallAuthorizationResponse:
        r"""Enable Transaction Bundling

        Get authorization for bundling transactions.

        Currently this is required for every transaction bundle to prevent replay attacks
        and ensure transaction ordering when batching multiple actions into a single
        transaction. The authorization includes a nonce and chain ID to guarantee
        transaction uniqueness and proper network targeting.

        :param chain:
        :param sender: The Ethereum address to use for authorization
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MulticallAuthorizationRequest(
            chain=chain,
            sender=sender,
        )

        req = self._build_request(
            method="POST",
            path="/v1/transaction_bundler/authorization",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MulticallAuthorizationRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_transaction_bundler_authorization",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MulticallAuthorizationResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def transaction_bundler_authorization_async(
        self,
        *,
        chain: models.MulticallAuthorizationRequestChain,
        sender: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MulticallAuthorizationResponse:
        r"""Enable Transaction Bundling

        Get authorization for bundling transactions.

        Currently this is required for every transaction bundle to prevent replay attacks
        and ensure transaction ordering when batching multiple actions into a single
        transaction. The authorization includes a nonce and chain ID to guarantee
        transaction uniqueness and proper network targeting.

        :param chain:
        :param sender: The Ethereum address to use for authorization
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MulticallAuthorizationRequest(
            chain=chain,
            sender=sender,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/transaction_bundler/authorization",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MulticallAuthorizationRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_transaction_bundler_authorization",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MulticallAuthorizationResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def transaction_bundler_execute(
        self,
        *,
        chain: models.MulticallExecuteRequestChain,
        sender: str,
        actions: Union[List[models.UserOperation], List[models.UserOperationTypedDict]],
        estimate_gas: Optional[bool] = None,
        signed_authorization: OptionalNullable[
            Union[models.SignedAuthorization, models.SignedAuthorizationTypedDict]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.BundlerTransactionResponse:
        r"""Construct Bundled Transaction

        Bundle arbitrary transactions together into a single multicall transaction using
        EIP-7702.

        This endpoint allows bundling multiple contract calls into a single atomic
        transaction, reducing gas costs and ensuring all operations succeed or fail
        together. The transaction must be authorized using the /authorization endpoint to
        prevent replay attacks.

        :param chain:
        :param sender: The address of the transaction sender.
        :param actions: List of possible actions for multicall
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param signed_authorization: EIP-7702 authorization
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MulticallExecuteRequest(
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
            signed_authorization=utils.get_pydantic_model(
                signed_authorization, OptionalNullable[models.SignedAuthorization]
            ),
            actions=utils.get_pydantic_model(actions, List[models.UserOperation]),
        )

        req = self._build_request(
            method="POST",
            path="/v1/transaction_bundler/execute",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MulticallExecuteRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_transaction_bundler_execute",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.BundlerTransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def transaction_bundler_execute_async(
        self,
        *,
        chain: models.MulticallExecuteRequestChain,
        sender: str,
        actions: Union[List[models.UserOperation], List[models.UserOperationTypedDict]],
        estimate_gas: Optional[bool] = None,
        signed_authorization: OptionalNullable[
            Union[models.SignedAuthorization, models.SignedAuthorizationTypedDict]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.BundlerTransactionResponse:
        r"""Construct Bundled Transaction

        Bundle arbitrary transactions together into a single multicall transaction using
        EIP-7702.

        This endpoint allows bundling multiple contract calls into a single atomic
        transaction, reducing gas costs and ensuring all operations succeed or fail
        together. The transaction must be authorized using the /authorization endpoint to
        prevent replay attacks.

        :param chain:
        :param sender: The address of the transaction sender.
        :param actions: List of possible actions for multicall
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param signed_authorization: EIP-7702 authorization
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MulticallExecuteRequest(
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
            signed_authorization=utils.get_pydantic_model(
                signed_authorization, OptionalNullable[models.SignedAuthorization]
            ),
            actions=utils.get_pydantic_model(actions, List[models.UserOperation]),
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/transaction_bundler/execute",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MulticallExecuteRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_transaction_bundler_execute",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.BundlerTransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def transaction_bundler_aave_loop(
        self,
        *,
        chain: models.AaveLoopRequestChain,
        sender: str,
        collateral_token: str,
        borrow_token: str,
        initial_collateral_amount: Union[
            models.InitialCollateralAmount, models.InitialCollateralAmountTypedDict
        ],
        multiplier: Union[models.Multiplier, models.MultiplierTypedDict],
        max_slippage_percent: Union[
            models.MaxSlippagePercent, models.MaxSlippagePercentTypedDict
        ],
        loan_to_value: Union[models.LoanToValue, models.LoanToValueTypedDict],
        estimate_gas: Optional[bool] = None,
        signed_authorization: OptionalNullable[
            Union[models.SignedAuthorization, models.SignedAuthorizationTypedDict]
        ] = UNSET,
        is_account_abstraction: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ResponseV1TransactionBundlerAaveLoop:
        r"""AAVE Leverage Long/Short

        Execute an Aave looping strategy that involves repeated supply and borrow
        operations.

        This endpoint creates a multicall transaction that performs a series of operations:
        1. Approves and supplies initial token
        2. For each loop:
        - Borrows another token
        - Swaps borrowed token back to supply token
        - Supplies the swapped tokens

        The transaction must be authorized using the /authorization endpoint to prevent replay attacks.

        :param chain:
        :param sender: The address of the transaction sender.
        :param collateral_token: Symbol or address of token to supply to Aave..
        :param borrow_token: Symbol or address of token to borrow from Aave..
        :param initial_collateral_amount: Amount of collateral token to supply to Aave
        :param multiplier: Leverage multiplier. Total loop collateral will be calculated as `multiplier` x `initial_collateral_amount`
        :param max_slippage_percent: Maximum allowed slippage for token swaps in percentage
        :param loan_to_value: Loan To Value percentage of the loop
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param signed_authorization: EIP-7702 authorization. Required when `is_account_abstraction` is False.
        :param is_account_abstraction: Whether to use account abstraction for the transaction.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveLoopRequest(
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
            signed_authorization=utils.get_pydantic_model(
                signed_authorization, OptionalNullable[models.SignedAuthorization]
            ),
            collateral_token=collateral_token,
            borrow_token=borrow_token,
            initial_collateral_amount=initial_collateral_amount,
            multiplier=multiplier,
            max_slippage_percent=max_slippage_percent,
            loan_to_value=loan_to_value,
            is_account_abstraction=is_account_abstraction,
        )

        req = self._build_request(
            method="POST",
            path="/v1/transaction_bundler/aave/loop",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveLoopRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_transaction_bundler_aave_loop",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ResponseV1TransactionBundlerAaveLoop, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def transaction_bundler_aave_loop_async(
        self,
        *,
        chain: models.AaveLoopRequestChain,
        sender: str,
        collateral_token: str,
        borrow_token: str,
        initial_collateral_amount: Union[
            models.InitialCollateralAmount, models.InitialCollateralAmountTypedDict
        ],
        multiplier: Union[models.Multiplier, models.MultiplierTypedDict],
        max_slippage_percent: Union[
            models.MaxSlippagePercent, models.MaxSlippagePercentTypedDict
        ],
        loan_to_value: Union[models.LoanToValue, models.LoanToValueTypedDict],
        estimate_gas: Optional[bool] = None,
        signed_authorization: OptionalNullable[
            Union[models.SignedAuthorization, models.SignedAuthorizationTypedDict]
        ] = UNSET,
        is_account_abstraction: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ResponseV1TransactionBundlerAaveLoop:
        r"""AAVE Leverage Long/Short

        Execute an Aave looping strategy that involves repeated supply and borrow
        operations.

        This endpoint creates a multicall transaction that performs a series of operations:
        1. Approves and supplies initial token
        2. For each loop:
        - Borrows another token
        - Swaps borrowed token back to supply token
        - Supplies the swapped tokens

        The transaction must be authorized using the /authorization endpoint to prevent replay attacks.

        :param chain:
        :param sender: The address of the transaction sender.
        :param collateral_token: Symbol or address of token to supply to Aave..
        :param borrow_token: Symbol or address of token to borrow from Aave..
        :param initial_collateral_amount: Amount of collateral token to supply to Aave
        :param multiplier: Leverage multiplier. Total loop collateral will be calculated as `multiplier` x `initial_collateral_amount`
        :param max_slippage_percent: Maximum allowed slippage for token swaps in percentage
        :param loan_to_value: Loan To Value percentage of the loop
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param signed_authorization: EIP-7702 authorization. Required when `is_account_abstraction` is False.
        :param is_account_abstraction: Whether to use account abstraction for the transaction.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveLoopRequest(
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
            signed_authorization=utils.get_pydantic_model(
                signed_authorization, OptionalNullable[models.SignedAuthorization]
            ),
            collateral_token=collateral_token,
            borrow_token=borrow_token,
            initial_collateral_amount=initial_collateral_amount,
            multiplier=multiplier,
            max_slippage_percent=max_slippage_percent,
            loan_to_value=loan_to_value,
            is_account_abstraction=is_account_abstraction,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/transaction_bundler/aave/loop",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveLoopRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_transaction_bundler_aave_loop",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ResponseV1TransactionBundlerAaveLoop, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
