"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Sky(BaseSDK):
    def sky_position(
        self,
        *,
        chain: models.V1SkyPositionChain,
        user_address: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SkyCheckPositionResponse:
        r"""Check USDS Position

        Check the USDS overall position.

        :param chain:
        :param user_address: The user-address of the desired position.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1SkyPositionRequest(
            chain=chain,
            user_address=user_address,
        )

        req = self._build_request(
            method="GET",
            path="/v1/sky/position",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_position",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SkyCheckPositionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def sky_position_async(
        self,
        *,
        chain: models.V1SkyPositionChain,
        user_address: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SkyCheckPositionResponse:
        r"""Check USDS Position

        Check the USDS overall position.

        :param chain:
        :param user_address: The user-address of the desired position.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1SkyPositionRequest(
            chain=chain,
            user_address=user_address,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/sky/position",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_position",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SkyCheckPositionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def sky_buy(
        self,
        *,
        token_in: models.SkyBuyRequestTokenIn,
        amount: Union[models.SkyBuyRequestAmount, models.SkyBuyRequestAmountTypedDict],
        chain: models.SkyBuyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Buy USDS

        Buy USDS with DAI or USDC on a 1:1 basis. There are no fees.

        If buying with DAI, user will need to set an allowance on the DAI contract for the
        'SkyDaiUsdsConverter' contract beforehand.

        If buying with USDC, user will need to set an allowance on the USDC contract for the
        'SkyUsdcUsdsConverter' contract beforehand.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdcUsdsConverter`
        - `SkyDaiUsdsConverter`
        </Info>


        :param token_in: The token you would like to swap 1:1 for USDS. Choose from DAI or USDC.
        :param amount: The amount of USDS you would like to buy 1:1 with 'token_in'.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkyBuyRequest(
            token_in=token_in,
            amount=amount,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/sky/buy",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkyBuyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_buy",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def sky_buy_async(
        self,
        *,
        token_in: models.SkyBuyRequestTokenIn,
        amount: Union[models.SkyBuyRequestAmount, models.SkyBuyRequestAmountTypedDict],
        chain: models.SkyBuyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Buy USDS

        Buy USDS with DAI or USDC on a 1:1 basis. There are no fees.

        If buying with DAI, user will need to set an allowance on the DAI contract for the
        'SkyDaiUsdsConverter' contract beforehand.

        If buying with USDC, user will need to set an allowance on the USDC contract for the
        'SkyUsdcUsdsConverter' contract beforehand.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdcUsdsConverter`
        - `SkyDaiUsdsConverter`
        </Info>


        :param token_in: The token you would like to swap 1:1 for USDS. Choose from DAI or USDC.
        :param amount: The amount of USDS you would like to buy 1:1 with 'token_in'.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkyBuyRequest(
            token_in=token_in,
            amount=amount,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/sky/buy",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkyBuyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_buy",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def sky_sell(
        self,
        *,
        token_out: models.SkySellRequestTokenOut,
        amount: Union[
            models.SkySellRequestAmount, models.SkySellRequestAmountTypedDict
        ],
        chain: models.SkySellRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Sell USDS

        Sell USDS for DAI or USDC on a 1:1 basis. There are no fees.

        If swapping to DAI, user will need to set an allowance on the USDS contract for the
        'SkyDaiUsdsConverter' contract beforehand.

        If swapping to USDC, user will need to set an allowance on the USDS contract for the
        'SkyUsdcUsdsConverter' contract beforehand.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdcUsdsConverter`
        - `SkyDaiUsdsConverter`
        </Info>


        :param token_out: The token you would like to swap 1:1 with USDS. Choose from DAI or USDC.
        :param amount: The amount of USDS you would like to sell 1:1 for 'token_out'.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkySellRequest(
            token_out=token_out,
            amount=amount,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/sky/sell",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkySellRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_sell",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def sky_sell_async(
        self,
        *,
        token_out: models.SkySellRequestTokenOut,
        amount: Union[
            models.SkySellRequestAmount, models.SkySellRequestAmountTypedDict
        ],
        chain: models.SkySellRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Sell USDS

        Sell USDS for DAI or USDC on a 1:1 basis. There are no fees.

        If swapping to DAI, user will need to set an allowance on the USDS contract for the
        'SkyDaiUsdsConverter' contract beforehand.

        If swapping to USDC, user will need to set an allowance on the USDS contract for the
        'SkyUsdcUsdsConverter' contract beforehand.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdcUsdsConverter`
        - `SkyDaiUsdsConverter`
        </Info>


        :param token_out: The token you would like to swap 1:1 with USDS. Choose from DAI or USDC.
        :param amount: The amount of USDS you would like to sell 1:1 for 'token_out'.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkySellRequest(
            token_out=token_out,
            amount=amount,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/sky/sell",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkySellRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_sell",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def sky_deposit(
        self,
        *,
        amount: Union[
            models.SkyDepositRequestAmount, models.SkyDepositRequestAmountTypedDict
        ],
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        chain: Optional[models.SkyDepositRequestChain] = None,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Deposit USDS

        Deposit USDS to earn yield. Deposited USDS is represented as sUSDS.

        Allowance must be set on USDS contract for UsdsVault.

        There are no fees.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdsVault`
        </Info>


        :param amount: The amount of USDS you would like to deposit for sUSDS to earn yield.
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the sUSDS. Defaults to the sender.
        :param chain:
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkyDepositRequest(
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/sky/deposit",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkyDepositRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_deposit",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def sky_deposit_async(
        self,
        *,
        amount: Union[
            models.SkyDepositRequestAmount, models.SkyDepositRequestAmountTypedDict
        ],
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        chain: Optional[models.SkyDepositRequestChain] = None,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Deposit USDS

        Deposit USDS to earn yield. Deposited USDS is represented as sUSDS.

        Allowance must be set on USDS contract for UsdsVault.

        There are no fees.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdsVault`
        </Info>


        :param amount: The amount of USDS you would like to deposit for sUSDS to earn yield.
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the sUSDS. Defaults to the sender.
        :param chain:
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkyDepositRequest(
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/sky/deposit",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkyDepositRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_deposit",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def sky_withdraw(
        self,
        *,
        amount: Any,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        chain: Optional[models.SkyWithdrawRequestChain] = None,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw USDS

        Withdraw USDS. Exchange yield-bearing sUSDS for USDS.

        Allowance must be set on USDS contract for UsdsVault.

        There are no fees.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdsVault`
        </Info>


        :param amount: The amount of USDS you would like to withdraw. If set to 'ALL', your total deposited USDS amount will be withdrawn.
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the withdrawn USDS. Defaults to the sender.
        :param chain:
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkyWithdrawRequest(
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/sky/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkyWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def sky_withdraw_async(
        self,
        *,
        amount: Any,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        chain: Optional[models.SkyWithdrawRequestChain] = None,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw USDS

        Withdraw USDS. Exchange yield-bearing sUSDS for USDS.

        Allowance must be set on USDS contract for UsdsVault.

        There are no fees.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `SkyUsdsVault`
        </Info>


        :param amount: The amount of USDS you would like to withdraw. If set to 'ALL', your total deposited USDS amount will be withdrawn.
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the withdrawn USDS. Defaults to the sender.
        :param chain:
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SkyWithdrawRequest(
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/sky/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SkyWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_sky_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
