"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Morpho(BaseSDK):
    def morpho_vaults(
        self,
        *,
        chain: models.V1MorphoVaultsChain,
        deposit_token: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoGetVaultsResponse:
        r"""Get Vaults

        Query a list of vaults you can deposit into.

        Each vault has one unique token that can be deposited. In exchange for depositing
        tokens into a vault you receive shares. You earn yield on these shares by their
        exchange value increasing over time.

        :param chain:
        :param deposit_token: Symbol or address of the deposit token to filter vaults by. Optional parameter.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoVaultsRequest(
            chain=chain,
            deposit_token=deposit_token,
        )

        req = self._build_request(
            method="GET",
            path="/v1/morpho/vaults",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_vaults",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MorphoGetVaultsResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_vaults_async(
        self,
        *,
        chain: models.V1MorphoVaultsChain,
        deposit_token: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoGetVaultsResponse:
        r"""Get Vaults

        Query a list of vaults you can deposit into.

        Each vault has one unique token that can be deposited. In exchange for depositing
        tokens into a vault you receive shares. You earn yield on these shares by their
        exchange value increasing over time.

        :param chain:
        :param deposit_token: Symbol or address of the deposit token to filter vaults by. Optional parameter.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoVaultsRequest(
            chain=chain,
            deposit_token=deposit_token,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/morpho/vaults",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_vaults",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MorphoGetVaultsResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_vault(
        self,
        *,
        chain: models.V1MorphoVaultChain,
        vault_address: str,
        block: OptionalNullable[int] = UNSET,
        user_address: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.VaultGetVaultResponse:
        r"""Get Vault & User Position

        Get Vault data & User Position.

        The user position is only included if 'user_address' parameter is included.

        :param chain:
        :param vault_address: The vault address of the desired vault position.
        :param block: Optional block number (defaults to latest).
        :param user_address: The user address of the desired vault position. Only include if you would like the user position included in the response. Defaults to `None`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoVaultRequest(
            chain=chain,
            block=block,
            vault_address=vault_address,
            user_address=user_address,
        )

        req = self._build_request(
            method="GET",
            path="/v1/morpho/vault",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_vault",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.VaultGetVaultResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_vault_async(
        self,
        *,
        chain: models.V1MorphoVaultChain,
        vault_address: str,
        block: OptionalNullable[int] = UNSET,
        user_address: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.VaultGetVaultResponse:
        r"""Get Vault & User Position

        Get Vault data & User Position.

        The user position is only included if 'user_address' parameter is included.

        :param chain:
        :param vault_address: The vault address of the desired vault position.
        :param block: Optional block number (defaults to latest).
        :param user_address: The user address of the desired vault position. Only include if you would like the user position included in the response. Defaults to `None`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoVaultRequest(
            chain=chain,
            block=block,
            vault_address=vault_address,
            user_address=user_address,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/morpho/vault",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_vault",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.VaultGetVaultResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_markets(
        self,
        *,
        chain: models.V1MorphoMarketsChain,
        collateral_token: OptionalNullable[str] = UNSET,
        loan_token: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoGetMarketsResponse:
        r"""Get Markets

        Query a list of markets you can borrow from.

        Each market has one unique token that can be borrowed against one unique token that
        can be used as collateral.

        :param chain:
        :param collateral_token: Symbol or address of the collateral token to filter markets by. Optional parameter.
        :param loan_token: Symbol or address of the loan token to filter markets by. Optional parameter.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoMarketsRequest(
            chain=chain,
            collateral_token=collateral_token,
            loan_token=loan_token,
        )

        req = self._build_request(
            method="GET",
            path="/v1/morpho/markets",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_markets",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MorphoGetMarketsResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_markets_async(
        self,
        *,
        chain: models.V1MorphoMarketsChain,
        collateral_token: OptionalNullable[str] = UNSET,
        loan_token: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoGetMarketsResponse:
        r"""Get Markets

        Query a list of markets you can borrow from.

        Each market has one unique token that can be borrowed against one unique token that
        can be used as collateral.

        :param chain:
        :param collateral_token: Symbol or address of the collateral token to filter markets by. Optional parameter.
        :param loan_token: Symbol or address of the loan token to filter markets by. Optional parameter.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoMarketsRequest(
            chain=chain,
            collateral_token=collateral_token,
            loan_token=loan_token,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/morpho/markets",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_markets",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MorphoGetMarketsResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_market(
        self,
        *,
        chain: models.V1MorphoMarketChain,
        unique_market_key: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoGetMarketResponse:
        r"""Get Market

        Get data & metrics for a specific Morpho market.

        Including:
        - Current, daily, weekly, monthly, yearly APY
        - Collateral & loan asset data
        - Liquidation loan-to-value ratio
        - Collateral, borrow & liquidity value
        - Utilization ratio
        - Pertinent metadata
        - Whitelist status

        :param chain:
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoMarketRequest(
            chain=chain,
            unique_market_key=unique_market_key,
        )

        req = self._build_request(
            method="GET",
            path="/v1/morpho/market",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_market",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MorphoGetMarketResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_market_async(
        self,
        *,
        chain: models.V1MorphoMarketChain,
        unique_market_key: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoGetMarketResponse:
        r"""Get Market

        Get data & metrics for a specific Morpho market.

        Including:
        - Current, daily, weekly, monthly, yearly APY
        - Collateral & loan asset data
        - Liquidation loan-to-value ratio
        - Collateral, borrow & liquidity value
        - Utilization ratio
        - Pertinent metadata
        - Whitelist status

        :param chain:
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoMarketRequest(
            chain=chain,
            unique_market_key=unique_market_key,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/morpho/market",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_market",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.MorphoGetMarketResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_market_position(
        self,
        *,
        chain: models.V1MorphoMarketPositionChain,
        user_address: str,
        unique_market_key: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoCheckMarketPositionResponse:
        r"""Check Market Position

        Check how many shares you've borrowed and the equivalent token amount of a given
        market.

        :param chain:
        :param user_address: The user address of the desired market position.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoMarketPositionRequest(
            chain=chain,
            user_address=user_address,
            unique_market_key=unique_market_key,
        )

        req = self._build_request(
            method="GET",
            path="/v1/morpho/market_position",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_market_position",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MorphoCheckMarketPositionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_market_position_async(
        self,
        *,
        chain: models.V1MorphoMarketPositionChain,
        user_address: str,
        unique_market_key: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoCheckMarketPositionResponse:
        r"""Check Market Position

        Check how many shares you've borrowed and the equivalent token amount of a given
        market.

        :param chain:
        :param user_address: The user address of the desired market position.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoMarketPositionRequest(
            chain=chain,
            user_address=user_address,
            unique_market_key=unique_market_key,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/morpho/market_position",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_market_position",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MorphoCheckMarketPositionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_user_position(
        self,
        *,
        chain: models.V1MorphoUserPositionChain,
        user_address: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoCheckUserPositionResponse:
        r"""Check User Position

        Check user's overall position across the entire Morpho ecosystem.

        Inlcuding all vault and market position metrics and relavant metadata of said vaults
        and markets.

        :param chain:
        :param user_address: The user wallet address of the desired user position.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoUserPositionRequest(
            chain=chain,
            user_address=user_address,
        )

        req = self._build_request(
            method="GET",
            path="/v1/morpho/user_position",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_user_position",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MorphoCheckUserPositionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_user_position_async(
        self,
        *,
        chain: models.V1MorphoUserPositionChain,
        user_address: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.MorphoCheckUserPositionResponse:
        r"""Check User Position

        Check user's overall position across the entire Morpho ecosystem.

        Inlcuding all vault and market position metrics and relavant metadata of said vaults
        and markets.

        :param chain:
        :param user_address: The user wallet address of the desired user position.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1MorphoUserPositionRequest(
            chain=chain,
            user_address=user_address,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/morpho/user_position",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_user_position",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MorphoCheckUserPositionResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_deposit(
        self,
        *,
        vault_address: str,
        amount: Union[
            models.MorphoDepositRequestAmount,
            models.MorphoDepositRequestAmountTypedDict,
        ],
        chain: models.MorphoDepositRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Deposit to Vault

        Deposit tokens into a Morpho Vault to earn passive yield from interest paid by
        borrowers.

        Each vault accepts one unique token that can be deposited.

        A Morpho Vault has one loan asset and can allocate deposits to multiple Morpho
        markets. Users can deposit into a vault to start earning passive yield from interest
        paid by borrowers. Vaults feature automated risk management, actively curating risk
        exposure for all deposited assets so users don't need to make these decisions
        themselves. Users maintain full control over their assets, can monitor the vault's
        state at any time, and withdraw their liquidity at their discretion.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `<vault-contract-address>`
        </Info>


        :param vault_address: The vault address you are depositing to.
        :param amount: The amount of tokens to deposit into the vault.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoDepositRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/morpho/deposit",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoDepositRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_deposit",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_deposit_async(
        self,
        *,
        vault_address: str,
        amount: Union[
            models.MorphoDepositRequestAmount,
            models.MorphoDepositRequestAmountTypedDict,
        ],
        chain: models.MorphoDepositRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Deposit to Vault

        Deposit tokens into a Morpho Vault to earn passive yield from interest paid by
        borrowers.

        Each vault accepts one unique token that can be deposited.

        A Morpho Vault has one loan asset and can allocate deposits to multiple Morpho
        markets. Users can deposit into a vault to start earning passive yield from interest
        paid by borrowers. Vaults feature automated risk management, actively curating risk
        exposure for all deposited assets so users don't need to make these decisions
        themselves. Users maintain full control over their assets, can monitor the vault's
        state at any time, and withdraw their liquidity at their discretion.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `<vault-contract-address>`
        </Info>


        :param vault_address: The vault address you are depositing to.
        :param amount: The amount of tokens to deposit into the vault.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoDepositRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/morpho/deposit",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoDepositRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_deposit",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_withdraw(
        self,
        *,
        vault_address: str,
        amount: Any,
        chain: models.MorphoWithdrawRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw from Vault

        Withdraw deposited tokens from a Morpho Vault.

        The passive yield earned on token deposits is represented by the increased value of
        the shares received upon depositing tokens.

        A Morpho Vault has one loan asset and can allocate deposits to multiple Morpho
        markets. Users can deposit into a vault to start earning passive yield from interest
        paid by borrowers. Vaults feature automated risk management, actively curating risk
        exposure for all deposited assets so users don't need to make these decisions
        themselves. Users maintain full control over their assets, can monitor the vault's
        state at any time, and withdraw their liquidity at their discretion.

        :param vault_address: The vault address you are withdrawing from.
        :param amount: The amount of tokens to withdraw from the vault. If set to 'ALL', your total deposited token amount will be withdrawn.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the tokens withdrawn. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoWithdrawRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/morpho/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_withdraw_async(
        self,
        *,
        vault_address: str,
        amount: Any,
        chain: models.MorphoWithdrawRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw from Vault

        Withdraw deposited tokens from a Morpho Vault.

        The passive yield earned on token deposits is represented by the increased value of
        the shares received upon depositing tokens.

        A Morpho Vault has one loan asset and can allocate deposits to multiple Morpho
        markets. Users can deposit into a vault to start earning passive yield from interest
        paid by borrowers. Vaults feature automated risk management, actively curating risk
        exposure for all deposited assets so users don't need to make these decisions
        themselves. Users maintain full control over their assets, can monitor the vault's
        state at any time, and withdraw their liquidity at their discretion.

        :param vault_address: The vault address you are withdrawing from.
        :param amount: The amount of tokens to withdraw from the vault. If set to 'ALL', your total deposited token amount will be withdrawn.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the tokens withdrawn. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoWithdrawRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/morpho/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_supply_collateral(
        self,
        *,
        amount: Union[
            models.MorphoSupplyCollateralRequestAmount,
            models.MorphoSupplyCollateralRequestAmountTypedDict,
        ],
        unique_market_key: str,
        chain: models.MorphoSupplyCollateralRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        callback_data: OptionalNullable[bytes] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Supply Collateral to Market

        Supply collateral to a Morpho Market in order to borrow against it.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to supply to the market as collateral.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supplied collateral is made. Defaults to sender.
        :param callback_data: An optional field for callback byte data that will be triggered upon successful supplying of collateral.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoSupplyCollateralRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            callback_data=callback_data,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/morpho/supply_collateral",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoSupplyCollateralRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_supply_collateral",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_supply_collateral_async(
        self,
        *,
        amount: Union[
            models.MorphoSupplyCollateralRequestAmount,
            models.MorphoSupplyCollateralRequestAmountTypedDict,
        ],
        unique_market_key: str,
        chain: models.MorphoSupplyCollateralRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        callback_data: OptionalNullable[bytes] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Supply Collateral to Market

        Supply collateral to a Morpho Market in order to borrow against it.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to supply to the market as collateral.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supplied collateral is made. Defaults to sender.
        :param callback_data: An optional field for callback byte data that will be triggered upon successful supplying of collateral.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoSupplyCollateralRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            callback_data=callback_data,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/morpho/supply_collateral",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoSupplyCollateralRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_supply_collateral",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_withdraw_collateral(
        self,
        *,
        amount: Union[
            models.MorphoWithdrawCollateralRequestAmount,
            models.MorphoWithdrawCollateralRequestAmountTypedDict,
        ],
        unique_market_key: str,
        chain: models.MorphoWithdrawCollateralRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw Collateral from Market

        Withdraw collateral that has been supplied to a Morpho Market.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to supply to the market as collateral.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the withdraw is made. Defaults to sender.
        :param receiver: The address where the withdrawn collateral will be received. Defaults to sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoWithdrawCollateralRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/morpho/withdraw_collateral",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoWithdrawCollateralRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_withdraw_collateral",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_withdraw_collateral_async(
        self,
        *,
        amount: Union[
            models.MorphoWithdrawCollateralRequestAmount,
            models.MorphoWithdrawCollateralRequestAmountTypedDict,
        ],
        unique_market_key: str,
        chain: models.MorphoWithdrawCollateralRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw Collateral from Market

        Withdraw collateral that has been supplied to a Morpho Market.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to supply to the market as collateral.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the withdraw is made. Defaults to sender.
        :param receiver: The address where the withdrawn collateral will be received. Defaults to sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoWithdrawCollateralRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/morpho/withdraw_collateral",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoWithdrawCollateralRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_withdraw_collateral",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_borrow(
        self,
        *,
        amount: Union[
            models.MorphoBorrowRequestAmount, models.MorphoBorrowRequestAmountTypedDict
        ],
        unique_market_key: str,
        chain: models.MorphoBorrowRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Borrow from Market

        Borrow tokens from a Morpho Market against supplied collateral.

        The position could be liquidated when a borrower's Loan-To-Value (LTV) exceeds the
        Liquidation Loan-To-Value (LLTV) threshold of the market.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to borrow from the market.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address where the collateral is borrowed against. Defaults to sender.
        :param receiver: The address of the receiver of the tokens borrowed. Defaults to the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoBorrowRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/morpho/borrow",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoBorrowRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_borrow",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_borrow_async(
        self,
        *,
        amount: Union[
            models.MorphoBorrowRequestAmount, models.MorphoBorrowRequestAmountTypedDict
        ],
        unique_market_key: str,
        chain: models.MorphoBorrowRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Borrow from Market

        Borrow tokens from a Morpho Market against supplied collateral.

        The position could be liquidated when a borrower's Loan-To-Value (LTV) exceeds the
        Liquidation Loan-To-Value (LLTV) threshold of the market.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to borrow from the market.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address where the collateral is borrowed against. Defaults to sender.
        :param receiver: The address of the receiver of the tokens borrowed. Defaults to the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoBorrowRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/morpho/borrow",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoBorrowRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_borrow",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def morpho_repay(
        self,
        *,
        amount: Any,
        unique_market_key: str,
        chain: models.MorphoRepayRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        callback_data: OptionalNullable[bytes] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Repay to Market

        Repay borrowed tokens to a market in order to reduce or eliminate debt.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to repay to the market. If set to 'ALL', all debt plus interest will be paid back if the user has a sufficient token balance in their wallet.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the repayment is made. Defaults to sender.
        :param callback_data: An optional field for callback byte data that will be triggered upon successful repaying of debt.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoRepayRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            callback_data=callback_data,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/morpho/repay",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoRepayRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_repay",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def morpho_repay_async(
        self,
        *,
        amount: Any,
        unique_market_key: str,
        chain: models.MorphoRepayRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        callback_data: OptionalNullable[bytes] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Repay to Market

        Repay borrowed tokens to a market in order to reduce or eliminate debt.

        A Morpho Market is a primitive lending pool that pairs one collateral asset with one
        loan asset. Each market is isolated (meaning risks are contained within each
        individual market), immutable (cannot be changed after deployment), and will persist
        as long as the blockchain it is deployed on is live.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `MorphoMarket`
        </Info>


        :param amount: Amount of the token to repay to the market. If set to 'ALL', all debt plus interest will be paid back if the user has a sufficient token balance in their wallet.
        :param unique_market_key: The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the repayment is made. Defaults to sender.
        :param callback_data: An optional field for callback byte data that will be triggered upon successful repaying of debt.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MorphoRepayRequest(
            amount=amount,
            unique_market_key=unique_market_key,
            on_behalf_of=on_behalf_of,
            callback_data=callback_data,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/morpho/repay",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MorphoRepayRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_morpho_repay",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
