"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


WrapEthRequestAmountTypedDict = TypeAliasType(
    "WrapEthRequestAmountTypedDict", Union[float, str]
)
r"""The amount of ETH to wrap."""


WrapEthRequestAmount = TypeAliasType("WrapEthRequestAmount", Union[float, str])
r"""The amount of ETH to wrap."""


class WrapEthRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class WrapEthRequestTypedDict(TypedDict):
    r"""Request model for wrapping ETH into WETH."""

    amount: WrapEthRequestAmountTypedDict
    r"""The amount of ETH to wrap."""
    chain: WrapEthRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["WRAP_ETH"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class WrapEthRequest(BaseModel):
    r"""Request model for wrapping ETH into WETH."""

    amount: WrapEthRequestAmount
    r"""The amount of ETH to wrap."""

    chain: WrapEthRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["WRAP_ETH"]], AfterValidator(validate_const("WRAP_ETH"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "WRAP_ETH"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
