"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


WrapEthParamsAmountTypedDict = TypeAliasType(
    "WrapEthParamsAmountTypedDict", Union[float, str]
)
r"""The amount of ETH to wrap."""


WrapEthParamsAmount = TypeAliasType("WrapEthParamsAmount", Union[float, str])
r"""The amount of ETH to wrap."""


class WrapEthParamsTypedDict(TypedDict):
    r"""Parameters model for wrapping ETH into WETH."""

    amount: WrapEthParamsAmountTypedDict
    r"""The amount of ETH to wrap."""
    action_type: Literal["WRAP_ETH"]


class WrapEthParams(BaseModel):
    r"""Parameters model for wrapping ETH into WETH."""

    amount: WrapEthParamsAmount
    r"""The amount of ETH to wrap."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["WRAP_ETH"]], AfterValidator(validate_const("WRAP_ETH"))
        ],
        pydantic.Field(alias="action_type"),
    ] = "WRAP_ETH"
