"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reserve import Reserve, ReserveTypedDict
from compass_api_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class WithdrawTypedDict(TypedDict):
    id: str
    r"""The id of a historical transaction on aave"""
    timestamp: int
    r"""Timestamp in unix time"""
    tx_hash: str
    r"""Transaction hash. You can paste these into the search bar on etherscan"""
    amount: float
    r"""Quantity of token"""
    reserve: ReserveTypedDict
    asset_price_usd: float
    r"""Price of token in USD"""
    action: str
    r"""The type of transaction"""
    block: int


class Withdraw(BaseModel):
    id: str
    r"""The id of a historical transaction on aave"""

    timestamp: int
    r"""Timestamp in unix time"""

    tx_hash: Annotated[str, pydantic.Field(alias="txHash")]
    r"""Transaction hash. You can paste these into the search bar on etherscan"""

    amount: float
    r"""Quantity of token"""

    reserve: Reserve

    asset_price_usd: Annotated[float, pydantic.Field(alias="assetPriceUSD")]
    r"""Price of token in USD"""

    action: str
    r"""The type of transaction"""

    block: int
