"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .compass_api_backend_v1_models_wildcat_read_response_market_userposition import (
    CompassAPIBackendV1ModelsWildcatReadResponseMarketUserPosition,
    CompassAPIBackendV1ModelsWildcatReadResponseMarketUserPositionTypedDict,
)
from .underlyingtoken import UnderlyingToken, UnderlyingTokenTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class WildcatGetMarketResponseTypedDict(TypedDict):
    market_address: str
    r"""The address of the market."""
    name: str
    r"""Name of the vault."""
    symbol: str
    r"""Symbol of the vault."""
    decimals: int
    r"""Number of decimals used for the vault's share precision."""
    available_to_lend: str
    r"""The borrower's remaining available credit."""
    loaned: str
    r"""The total value of all funds supplied by lenders, including interest."""
    max_borrowing_capacity: str
    r"""The maximum limit of funds that borrowers can access in the market."""
    gross_interest_accrued: str
    r"""The total gross interest generated by the loan before being split between lenders, reserves, and protocol fees."""
    minimum_deposit: str
    r"""The minimum amount of underlying asset required for a single deposit transaction."""
    minimum_reserve_ratio: str
    r"""A required percentage of market funds that must remain liquid and unavailable for borrowing."""
    base_lender_apr: str
    r"""The fixed annual percentage rate (excluding any protocol fees) that borrowers pay to lenders for assets within the market."""
    protocol_fee_apr: str
    r"""An additional APR that accrues to the protocol by slowly increasing required reserves. Derived by the fee configuration of the protocol as a percentage of the current base APR."""
    effective_lender_apr: str
    r"""The current interest rate being paid to lenders: the base APR plus penalty APR if applicable."""
    penalty_apr: str
    r"""An additional interest rate charged if the market remains delinquent—failing to maintain required reserves—after the grace period has elapsed."""
    maximum_grace_period: int
    r"""The number of seconds borrowers have to resolve reserve deficiencies or correct delinquency in the market before penalties take effect."""
    available_grace_period: int
    r"""The portion of the grace period left for borrowers to fix non-compliance issues, such as restoring reserves."""
    withdrawal_cycle_duration: int
    r"""The number of seconds for which withdrawal requests are grouped and processed."""
    underlying_token: UnderlyingTokenTypedDict
    user_position: NotRequired[
        Nullable[
            CompassAPIBackendV1ModelsWildcatReadResponseMarketUserPositionTypedDict
        ]
    ]
    r"""The user's position in the vault."""


class WildcatGetMarketResponse(BaseModel):
    market_address: str
    r"""The address of the market."""

    name: str
    r"""Name of the vault."""

    symbol: str
    r"""Symbol of the vault."""

    decimals: int
    r"""Number of decimals used for the vault's share precision."""

    available_to_lend: str
    r"""The borrower's remaining available credit."""

    loaned: str
    r"""The total value of all funds supplied by lenders, including interest."""

    max_borrowing_capacity: str
    r"""The maximum limit of funds that borrowers can access in the market."""

    gross_interest_accrued: str
    r"""The total gross interest generated by the loan before being split between lenders, reserves, and protocol fees."""

    minimum_deposit: str
    r"""The minimum amount of underlying asset required for a single deposit transaction."""

    minimum_reserve_ratio: str
    r"""A required percentage of market funds that must remain liquid and unavailable for borrowing."""

    base_lender_apr: str
    r"""The fixed annual percentage rate (excluding any protocol fees) that borrowers pay to lenders for assets within the market."""

    protocol_fee_apr: str
    r"""An additional APR that accrues to the protocol by slowly increasing required reserves. Derived by the fee configuration of the protocol as a percentage of the current base APR."""

    effective_lender_apr: str
    r"""The current interest rate being paid to lenders: the base APR plus penalty APR if applicable."""

    penalty_apr: str
    r"""An additional interest rate charged if the market remains delinquent—failing to maintain required reserves—after the grace period has elapsed."""

    maximum_grace_period: int
    r"""The number of seconds borrowers have to resolve reserve deficiencies or correct delinquency in the market before penalties take effect."""

    available_grace_period: int
    r"""The portion of the grace period left for borrowers to fix non-compliance issues, such as restoring reserves."""

    withdrawal_cycle_duration: int
    r"""The number of seconds for which withdrawal requests are grouped and processed."""

    underlying_token: UnderlyingToken

    user_position: OptionalNullable[
        CompassAPIBackendV1ModelsWildcatReadResponseMarketUserPosition
    ] = UNSET
    r"""The user's position in the vault."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["user_position"]
        nullable_fields = ["user_position"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
