"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class VaultInfoTypedDict(TypedDict):
    r"""Information about a single DeFi vault."""

    name: str
    r"""The name of the vault."""
    address: str
    r"""The vault contract address."""
    protocol: str
    r"""The DeFi protocol name."""
    denomination: str
    r"""The denomination token symbol (underlying asset)."""
    share_token: str
    r"""The vault share token symbol."""
    stablecoinish: bool
    r"""Whether the vault is denominated in a stablecoin."""
    id: NotRequired[Nullable[str]]
    r"""Unique vault identifier."""
    chain: NotRequired[Nullable[str]]
    r"""Blockchain name (e.g., 'ethereum', 'base')."""
    chain_id: NotRequired[Nullable[int]]
    r"""Blockchain chain ID."""
    lifetime_return: NotRequired[Nullable[str]]
    r"""Total lifetime return as a decimal (e.g., 0.093 = 9.3%)."""
    lifetime_return_net: NotRequired[Nullable[str]]
    r"""Total lifetime return after fees as a decimal."""
    cagr: NotRequired[Nullable[str]]
    r"""Compound Annual Growth Rate as a decimal."""
    cagr_net: NotRequired[Nullable[str]]
    r"""Compound Annual Growth Rate after fees as a decimal."""
    three_months_returns: NotRequired[Nullable[str]]
    r"""3-month returns as a decimal."""
    three_months_returns_net: NotRequired[Nullable[str]]
    r"""3-month returns after fees as a decimal."""
    three_months_cagr: NotRequired[Nullable[str]]
    r"""3-month CAGR as a decimal."""
    three_months_cagr_net: NotRequired[Nullable[str]]
    r"""3-month CAGR after fees as a decimal."""
    three_months_sharpe: NotRequired[Nullable[str]]
    r"""3-month Sharpe ratio."""
    three_months_sharpe_net: NotRequired[Nullable[str]]
    r"""3-month Sharpe ratio after fees."""
    three_months_volatility: NotRequired[Nullable[str]]
    r"""3-month volatility."""
    one_month_returns: NotRequired[Nullable[str]]
    r"""1-month returns as a decimal."""
    one_month_returns_net: NotRequired[Nullable[str]]
    r"""1-month returns after fees as a decimal."""
    one_month_cagr: NotRequired[Nullable[str]]
    r"""1-month CAGR as a decimal."""
    one_month_cagr_net: NotRequired[Nullable[str]]
    r"""1-month CAGR after fees as a decimal."""
    current_nav: NotRequired[Nullable[str]]
    r"""Current Net Asset Value in denomination token."""
    peak_nav: NotRequired[Nullable[str]]
    r"""Peak Net Asset Value in denomination token."""
    fee_label: NotRequired[Nullable[str]]
    r"""Human-readable fee structure label."""
    management_fee: NotRequired[Nullable[str]]
    r"""Management fee as a decimal."""
    performance_fee: NotRequired[Nullable[str]]
    r"""Performance fee as a decimal."""
    deposit_fee: NotRequired[Nullable[str]]
    r"""Deposit fee as a decimal."""
    withdraw_fee: NotRequired[Nullable[str]]
    r"""Withdrawal fee as a decimal."""
    years: NotRequired[Nullable[str]]
    r"""Age of the vault in years."""
    event_count: NotRequired[Nullable[int]]
    r"""Number of events/transactions in the vault."""
    features: NotRequired[Nullable[List[str]]]
    r"""List of vault features and capabilities."""


class VaultInfo(BaseModel):
    r"""Information about a single DeFi vault."""

    name: str
    r"""The name of the vault."""

    address: str
    r"""The vault contract address."""

    protocol: str
    r"""The DeFi protocol name."""

    denomination: str
    r"""The denomination token symbol (underlying asset)."""

    share_token: str
    r"""The vault share token symbol."""

    stablecoinish: bool
    r"""Whether the vault is denominated in a stablecoin."""

    id: OptionalNullable[str] = UNSET
    r"""Unique vault identifier."""

    chain: OptionalNullable[str] = UNSET
    r"""Blockchain name (e.g., 'ethereum', 'base')."""

    chain_id: OptionalNullable[int] = UNSET
    r"""Blockchain chain ID."""

    lifetime_return: OptionalNullable[str] = UNSET
    r"""Total lifetime return as a decimal (e.g., 0.093 = 9.3%)."""

    lifetime_return_net: OptionalNullable[str] = UNSET
    r"""Total lifetime return after fees as a decimal."""

    cagr: OptionalNullable[str] = UNSET
    r"""Compound Annual Growth Rate as a decimal."""

    cagr_net: OptionalNullable[str] = UNSET
    r"""Compound Annual Growth Rate after fees as a decimal."""

    three_months_returns: OptionalNullable[str] = UNSET
    r"""3-month returns as a decimal."""

    three_months_returns_net: OptionalNullable[str] = UNSET
    r"""3-month returns after fees as a decimal."""

    three_months_cagr: OptionalNullable[str] = UNSET
    r"""3-month CAGR as a decimal."""

    three_months_cagr_net: OptionalNullable[str] = UNSET
    r"""3-month CAGR after fees as a decimal."""

    three_months_sharpe: OptionalNullable[str] = UNSET
    r"""3-month Sharpe ratio."""

    three_months_sharpe_net: OptionalNullable[str] = UNSET
    r"""3-month Sharpe ratio after fees."""

    three_months_volatility: OptionalNullable[str] = UNSET
    r"""3-month volatility."""

    one_month_returns: OptionalNullable[str] = UNSET
    r"""1-month returns as a decimal."""

    one_month_returns_net: OptionalNullable[str] = UNSET
    r"""1-month returns after fees as a decimal."""

    one_month_cagr: OptionalNullable[str] = UNSET
    r"""1-month CAGR as a decimal."""

    one_month_cagr_net: OptionalNullable[str] = UNSET
    r"""1-month CAGR after fees as a decimal."""

    current_nav: OptionalNullable[str] = UNSET
    r"""Current Net Asset Value in denomination token."""

    peak_nav: OptionalNullable[str] = UNSET
    r"""Peak Net Asset Value in denomination token."""

    fee_label: OptionalNullable[str] = UNSET
    r"""Human-readable fee structure label."""

    management_fee: OptionalNullable[str] = UNSET
    r"""Management fee as a decimal."""

    performance_fee: OptionalNullable[str] = UNSET
    r"""Performance fee as a decimal."""

    deposit_fee: OptionalNullable[str] = UNSET
    r"""Deposit fee as a decimal."""

    withdraw_fee: OptionalNullable[str] = UNSET
    r"""Withdrawal fee as a decimal."""

    years: OptionalNullable[str] = UNSET
    r"""Age of the vault in years."""

    event_count: OptionalNullable[int] = UNSET
    r"""Number of events/transactions in the vault."""

    features: OptionalNullable[List[str]] = UNSET
    r"""List of vault features and capabilities."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "chain",
            "chain_id",
            "lifetime_return",
            "lifetime_return_net",
            "cagr",
            "cagr_net",
            "three_months_returns",
            "three_months_returns_net",
            "three_months_cagr",
            "three_months_cagr_net",
            "three_months_sharpe",
            "three_months_sharpe_net",
            "three_months_volatility",
            "one_month_returns",
            "one_month_returns_net",
            "one_month_cagr",
            "one_month_cagr_net",
            "current_nav",
            "peak_nav",
            "fee_label",
            "management_fee",
            "performance_fee",
            "deposit_fee",
            "withdraw_fee",
            "years",
            "event_count",
            "features",
        ]
        nullable_fields = [
            "id",
            "chain",
            "chain_id",
            "lifetime_return",
            "lifetime_return_net",
            "cagr",
            "cagr_net",
            "three_months_returns",
            "three_months_returns_net",
            "three_months_cagr",
            "three_months_cagr_net",
            "three_months_sharpe",
            "three_months_sharpe_net",
            "three_months_volatility",
            "one_month_returns",
            "one_month_returns_net",
            "one_month_cagr",
            "one_month_cagr_net",
            "current_nav",
            "peak_nav",
            "fee_label",
            "management_fee",
            "performance_fee",
            "deposit_fee",
            "withdraw_fee",
            "years",
            "event_count",
            "features",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
