"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


VaultDepositRequestAmountTypedDict = TypeAliasType(
    "VaultDepositRequestAmountTypedDict", Union[float, str]
)
r"""The amount of tokens to deposit into the vault."""


VaultDepositRequestAmount = TypeAliasType(
    "VaultDepositRequestAmount", Union[float, str]
)
r"""The amount of tokens to deposit into the vault."""


class VaultDepositRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class VaultDepositRequestTypedDict(TypedDict):
    vault_address: str
    r"""The vault address you are depositing to."""
    amount: VaultDepositRequestAmountTypedDict
    r"""The amount of tokens to deposit into the vault."""
    chain: VaultDepositRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["VAULT_DEPOSIT"]
    receiver: NotRequired[Nullable[str]]
    r"""The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender."""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class VaultDepositRequest(BaseModel):
    vault_address: str
    r"""The vault address you are depositing to."""

    amount: VaultDepositRequestAmount
    r"""The amount of tokens to deposit into the vault."""

    chain: VaultDepositRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["VAULT_DEPOSIT"]],
            AfterValidator(validate_const("VAULT_DEPOSIT")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "VAULT_DEPOSIT"

    receiver: OptionalNullable[str] = UNSET
    r"""The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender."""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "receiver", "estimate_gas"]
        nullable_fields = ["receiver"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
