"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Direction(str, Enum):
    r"""The direction to order the results by."""

    ASC = "asc"
    DESC = "desc"


class V2EarnVaultsChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V2EarnVaultsRequestTypedDict(TypedDict):
    order_by: str
    r"""The field to order the results by."""
    chain: V2EarnVaultsChain
    direction: NotRequired[Direction]
    r"""The direction to order the results by."""
    offset: NotRequired[int]
    r"""The offset of the first item to return."""
    limit: NotRequired[int]
    r"""The number of items to return."""


class V2EarnVaultsRequest(BaseModel):
    order_by: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The field to order the results by."""

    chain: Annotated[
        V2EarnVaultsChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    direction: Annotated[
        Optional[Direction],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The direction to order the results by."""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The offset of the first item to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The number of items to return."""
