"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2EarnPositionsChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V2EarnPositionsRequestTypedDict(TypedDict):
    chain: V2EarnPositionsChain
    user_address: str
    r"""The address of the user to get vault positions for."""
    offset: NotRequired[int]
    r"""The offset of the first item to return."""
    limit: NotRequired[int]
    r"""The number of items to return."""
    days: NotRequired[int]
    r"""How many days back from the current time to include in the blockchain scan."""


class V2EarnPositionsRequest(BaseModel):
    chain: Annotated[
        V2EarnPositionsChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    user_address: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The address of the user to get vault positions for."""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The offset of the first item to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The number of items to return."""

    days: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""How many days back from the current time to include in the blockchain scan."""
