"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V2EarnPositionsPositionIDRequestTypedDict(TypedDict):
    position_id: str
    r"""Base64-encoded position identifier"""
    user_address: str
    r"""The address of the user to get the position for."""
    days: NotRequired[int]
    r"""How many days back from the current time to include in the blockchain scan (vault positions only)."""


class V2EarnPositionsPositionIDRequest(BaseModel):
    position_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Base64-encoded position identifier"""

    user_address: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The address of the user to get the position for."""

    days: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""How many days back from the current time to include in the blockchain scan (vault positions only)."""
