"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class V1VaultsVaultChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1VaultsVaultRequestTypedDict(TypedDict):
    chain: V1VaultsVaultChain
    vault_address: str
    r"""The vault address of the desired vault position."""
    block: NotRequired[Nullable[int]]
    r"""Optional block number (defaults to latest)."""
    user_address: NotRequired[Nullable[str]]
    r"""The user address of the desired vault position. Only include if you would like the user position included in the response. Defaults to `None`."""


class V1VaultsVaultRequest(BaseModel):
    chain: Annotated[
        V1VaultsVaultChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    vault_address: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The vault address of the desired vault position."""

    block: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Optional block number (defaults to latest)."""

    user_address: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The user address of the desired vault position. Only include if you would like the user position included in the response. Defaults to `None`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["block", "user_address"]
        nullable_fields = ["block", "user_address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
