"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing import Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class V1UniswapQuoteSellExactlyChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1UniswapQuoteSellExactlyFeeEnum(str, Enum):
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    ZERO_DOT_01 = "0.01"
    ZERO_DOT_05 = "0.05"
    ZERO_DOT_3 = "0.3"
    ONE_DOT_0 = "1.0"


V1UniswapQuoteSellExactlyAmountInTypedDict = TypeAliasType(
    "V1UniswapQuoteSellExactlyAmountInTypedDict", Union[float, str]
)
r"""The amount of the token to swap from"""


V1UniswapQuoteSellExactlyAmountIn = TypeAliasType(
    "V1UniswapQuoteSellExactlyAmountIn", Union[float, str]
)
r"""The amount of the token to swap from"""


class V1UniswapQuoteSellExactlyRequestTypedDict(TypedDict):
    chain: V1UniswapQuoteSellExactlyChain
    token_in: str
    r"""The symbol or address of the token to swap from."""
    token_out: str
    r"""The symbol or address of the token to swap to."""
    fee: V1UniswapQuoteSellExactlyFeeEnum
    r"""The fee to pay for the swap"""
    amount_in: V1UniswapQuoteSellExactlyAmountInTypedDict
    r"""The amount of the token to swap from"""


class V1UniswapQuoteSellExactlyRequest(BaseModel):
    chain: Annotated[
        V1UniswapQuoteSellExactlyChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    token_in: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token to swap from."""

    token_out: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token to swap to."""

    fee: Annotated[
        V1UniswapQuoteSellExactlyFeeEnum,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The fee to pay for the swap"""

    amount_in: Annotated[
        V1UniswapQuoteSellExactlyAmountIn,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The amount of the token to swap from"""
