"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing import Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class V1UniswapQuoteBuyExactlyChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1UniswapQuoteBuyExactlyFeeEnum(str, Enum):
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    ZERO_DOT_01 = "0.01"
    ZERO_DOT_05 = "0.05"
    ZERO_DOT_3 = "0.3"
    ONE_DOT_0 = "1.0"


V1UniswapQuoteBuyExactlyAmountOutTypedDict = TypeAliasType(
    "V1UniswapQuoteBuyExactlyAmountOutTypedDict", Union[float, str]
)
r"""The amount of the token to swap to"""


V1UniswapQuoteBuyExactlyAmountOut = TypeAliasType(
    "V1UniswapQuoteBuyExactlyAmountOut", Union[float, str]
)
r"""The amount of the token to swap to"""


class V1UniswapQuoteBuyExactlyRequestTypedDict(TypedDict):
    chain: V1UniswapQuoteBuyExactlyChain
    token_in: str
    r"""The symbol or address of the token to swap from."""
    token_out: str
    r"""The symbol or address of the token to swap to."""
    fee: V1UniswapQuoteBuyExactlyFeeEnum
    r"""The fee to pay for the swap"""
    amount_out: V1UniswapQuoteBuyExactlyAmountOutTypedDict
    r"""The amount of the token to swap to"""


class V1UniswapQuoteBuyExactlyRequest(BaseModel):
    chain: Annotated[
        V1UniswapQuoteBuyExactlyChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    token_in: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token to swap from."""

    token_out: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token to swap to."""

    fee: Annotated[
        V1UniswapQuoteBuyExactlyFeeEnum,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The fee to pay for the swap"""

    amount_out: Annotated[
        V1UniswapQuoteBuyExactlyAmountOut,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The amount of the token to swap to"""
