"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing_extensions import Annotated, TypedDict


class V1UniswapPoolPriceChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1UniswapPoolPriceFeeEnum(str, Enum):
    r"""The transaction fee of a Uniswap pool in bips.

    Uniswap supports 4 different fee levels.
    """

    ZERO_DOT_01 = "0.01"
    ZERO_DOT_05 = "0.05"
    ZERO_DOT_3 = "0.3"
    ONE_DOT_0 = "1.0"


class V1UniswapPoolPriceRequestTypedDict(TypedDict):
    chain: V1UniswapPoolPriceChain
    token_in: str
    r"""The symbol or address of a token in the pool"""
    token_out: str
    r"""The symbol or address of a token in the pool"""
    fee: V1UniswapPoolPriceFeeEnum
    r"""The fee of the pool"""


class V1UniswapPoolPriceRequest(BaseModel):
    chain: Annotated[
        V1UniswapPoolPriceChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    token_in: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of a token in the pool"""

    token_out: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of a token in the pool"""

    fee: Annotated[
        V1UniswapPoolPriceFeeEnum,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The fee of the pool"""
