"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing_extensions import Annotated, TypedDict


class V1TokenBalanceChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1TokenBalanceRequestTypedDict(TypedDict):
    chain: V1TokenBalanceChain
    user: str
    r"""The user to get the token balance of."""
    token: str
    r"""The symbol or address of the token for which the balance is checked."""


class V1TokenBalanceRequest(BaseModel):
    chain: Annotated[
        V1TokenBalanceChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    user: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The user to get the token balance of."""

    token: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token for which the balance is checked."""
