"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class V1MorphoVaultsChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1MorphoVaultsRequestTypedDict(TypedDict):
    chain: V1MorphoVaultsChain
    deposit_token: NotRequired[Nullable[str]]
    r"""Symbol or address of the deposit token to filter vaults by. Optional parameter."""


class V1MorphoVaultsRequest(BaseModel):
    chain: Annotated[
        V1MorphoVaultsChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    deposit_token: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Symbol or address of the deposit token to filter vaults by. Optional parameter."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["deposit_token"]
        nullable_fields = ["deposit_token"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
