"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing_extensions import Annotated, TypedDict


class V1MorphoMarketPositionChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1MorphoMarketPositionRequestTypedDict(TypedDict):
    chain: V1MorphoMarketPositionChain
    user_address: str
    r"""The user address of the desired market position."""
    unique_market_key: str
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""


class V1MorphoMarketPositionRequest(BaseModel):
    chain: Annotated[
        V1MorphoMarketPositionChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    user_address: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The user address of the desired market position."""

    unique_market_key: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The key that uniquely identifies the market. This can be found using the 'Get Markets' endpoint."""
