"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .protocol import Protocol
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class V1GenericSupportedChainsRequestTypedDict(TypedDict):
    protocol: NotRequired[Nullable[Protocol]]
    r"""The protocol to get the supported chains for."""


class V1GenericSupportedChainsRequest(BaseModel):
    protocol: Annotated[
        OptionalNullable[Protocol],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The protocol to get the supported chains for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["protocol"]
        nullable_fields = ["protocol"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
