"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class V1GenericAllowanceChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1GenericAllowanceContractEnum(str, Enum):
    AAVE_V3_POOL = "AaveV3Pool"
    AERODROME_BASIC_ROUTER = "AerodromeBasicRouter"
    AERODROME_SLIPSTREAM_ROUTER = "AerodromeSlipstreamRouter"
    AERODROME_SLIPSTREAM_NONFUNGIBLE_POSITION_MANAGER = (
        "AerodromeSlipstreamNonfungiblePositionManager"
    )
    UNISWAP_V3_ROUTER = "UniswapV3Router"
    UNISWAP_V3_NFT_POSITION_MANAGER = "UniswapV3NFTPositionManager"
    MORPHO_MARKET = "MorphoMarket"
    SKY_DAI_USDS_CONVERTER = "SkyDaiUsdsConverter"
    SKY_USDC_USDS_CONVERTER = "SkyUsdcUsdsConverter"
    SKY_USDS_VAULT = "SkyUsdsVault"
    PENDLE_ROUTER = "PendleRouter"
    ODOS_ROUTER = "OdosRouter"
    ETHENA_VAULT = "EthenaVault"


V1GenericAllowanceContractUnionTypedDict = TypeAliasType(
    "V1GenericAllowanceContractUnionTypedDict",
    Union[V1GenericAllowanceContractEnum, str],
)
r"""The name or address of the contract to check allowance for."""


V1GenericAllowanceContractUnion = TypeAliasType(
    "V1GenericAllowanceContractUnion", Union[V1GenericAllowanceContractEnum, str]
)
r"""The name or address of the contract to check allowance for."""


class V1GenericAllowanceRequestTypedDict(TypedDict):
    chain: V1GenericAllowanceChain
    token: str
    r"""The symbol or address of the token for which the allowance is checked."""
    contract: V1GenericAllowanceContractUnionTypedDict
    r"""The name or address of the contract to check allowance for."""
    user: NotRequired[str]
    r"""The user to get the ERC20 allowance of."""


class V1GenericAllowanceRequest(BaseModel):
    chain: Annotated[
        V1GenericAllowanceChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    token: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token for which the allowance is checked."""

    contract: Annotated[
        V1GenericAllowanceContractUnion,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The name or address of the contract to check allowance for."""

    user: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The user to get the ERC20 allowance of."""
