"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V1AerodromeSlipstreamLiquidityProvisionPositionsChain(str, Enum):
    BASE = "base"


class V1AerodromeSlipstreamLiquidityProvisionPositionsRequestTypedDict(TypedDict):
    chain: V1AerodromeSlipstreamLiquidityProvisionPositionsChain
    user: NotRequired[str]
    r"""The user to get positions for."""
    pool: NotRequired[Nullable[str]]
    r"""Optional pool address to filter positions by. If provided, only positions for this pool will be returned."""


class V1AerodromeSlipstreamLiquidityProvisionPositionsRequest(BaseModel):
    chain: Annotated[
        V1AerodromeSlipstreamLiquidityProvisionPositionsChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    user: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The user to get positions for."""

    pool: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Optional pool address to filter positions by. If provided, only positions for this pool will be returned."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["user", "pool"]
        nullable_fields = ["pool"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
