"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing_extensions import Annotated, TypedDict


class V1AaveLiquidityChangeChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1AaveLiquidityChangeRequestTypedDict(TypedDict):
    chain: V1AaveLiquidityChangeChain
    token: str
    r"""The symbol or address of the asset to get liquidity change for.."""
    start_block: int
    r"""The start block to calculate liquidity change from."""
    end_block: int
    r"""The end block to calculate liquidity change to."""


class V1AaveLiquidityChangeRequest(BaseModel):
    chain: Annotated[
        V1AaveLiquidityChangeChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    token: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the asset to get liquidity change for.."""

    start_block: Annotated[
        int, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The start block to calculate liquidity change from."""

    end_block: Annotated[
        int, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The end block to calculate liquidity change to."""
