"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V1AaveHistoricalTransactionsChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1AaveHistoricalTransactionsRequestTypedDict(TypedDict):
    chain: V1AaveHistoricalTransactionsChain
    user_address: str
    r"""The address of the user to get historical transactions for."""
    offset: NotRequired[int]
    r"""The offset of the first item to return."""
    limit: NotRequired[int]
    r"""The number of items to return."""


class V1AaveHistoricalTransactionsRequest(BaseModel):
    chain: Annotated[
        V1AaveHistoricalTransactionsChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    user_address: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The address of the user to get historical transactions for."""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The offset of the first item to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The number of items to return."""
