"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class V1AaveAvgRateChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class V1AaveAvgRateRequestTypedDict(TypedDict):
    chain: V1AaveAvgRateChain
    token: str
    r"""The symbol or address of the token.."""
    days: int
    r"""The number of days for which the average shall be calculated."""
    block: NotRequired[Nullable[int]]
    r"""Optional block number (defaults to latest)."""


class V1AaveAvgRateRequest(BaseModel):
    chain: Annotated[
        V1AaveAvgRateChain,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]

    token: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The symbol or address of the token.."""

    days: Annotated[
        int, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The number of days for which the average shall be calculated."""

    block: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Optional block number (defaults to latest)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["block"]
        nullable_fields = ["block"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
