"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reserve import Reserve, ReserveTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class UsageAsCollateralTypedDict(TypedDict):
    id: str
    r"""The id of a historical transaction on aave"""
    timestamp: int
    r"""Timestamp in unix time"""
    tx_hash: str
    r"""Transaction hash. You can paste these into the search bar on etherscan"""
    from_state: bool
    to_state: bool
    reserve: ReserveTypedDict
    block: int
    action: Literal["UsageAsCollateral"]
    r"""The type of transaction"""


class UsageAsCollateral(BaseModel):
    id: str
    r"""The id of a historical transaction on aave"""

    timestamp: int
    r"""Timestamp in unix time"""

    tx_hash: Annotated[str, pydantic.Field(alias="txHash")]
    r"""Transaction hash. You can paste these into the search bar on etherscan"""

    from_state: Annotated[bool, pydantic.Field(alias="fromState")]

    to_state: Annotated[bool, pydantic.Field(alias="toState")]

    reserve: Reserve

    block: int

    ACTION: Annotated[
        Annotated[
            Literal["UsageAsCollateral"],
            AfterValidator(validate_const("UsageAsCollateral")),
        ],
        pydantic.Field(alias="action"),
    ] = "UsageAsCollateral"
    r"""The type of transaction"""
