"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UnwrapWethRequestAmountTypedDict = TypeAliasType(
    "UnwrapWethRequestAmountTypedDict", Union[float, str]
)
r"""The amount of WETH to unwrap."""


UnwrapWethRequestAmount = TypeAliasType("UnwrapWethRequestAmount", Union[float, str])
r"""The amount of WETH to unwrap."""


class UnwrapWethRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class UnwrapWethRequestTypedDict(TypedDict):
    r"""Request model for unwrapping WETH back to native ETH."""

    amount: UnwrapWethRequestAmountTypedDict
    r"""The amount of WETH to unwrap."""
    chain: UnwrapWethRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["UNWRAP_WETH"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class UnwrapWethRequest(BaseModel):
    r"""Request model for unwrapping WETH back to native ETH."""

    amount: UnwrapWethRequestAmount
    r"""The amount of WETH to unwrap."""

    chain: UnwrapWethRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNWRAP_WETH"]],
            AfterValidator(validate_const("UNWRAP_WETH")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNWRAP_WETH"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
