"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


UnwrapWethParamsAmountTypedDict = TypeAliasType(
    "UnwrapWethParamsAmountTypedDict", Union[float, str]
)
r"""The amount of WETH to unwrap."""


UnwrapWethParamsAmount = TypeAliasType("UnwrapWethParamsAmount", Union[float, str])
r"""The amount of WETH to unwrap."""


class UnwrapWethParamsTypedDict(TypedDict):
    r"""Parameters model for unwrapping WETH back to native ETH."""

    amount: UnwrapWethParamsAmountTypedDict
    r"""The amount of WETH to unwrap."""
    action_type: Literal["UNWRAP_WETH"]


class UnwrapWethParams(BaseModel):
    r"""Parameters model for unwrapping WETH back to native ETH."""

    amount: UnwrapWethParamsAmount
    r"""The amount of WETH to unwrap."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["UNWRAP_WETH"]],
            AfterValidator(validate_const("UNWRAP_WETH")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "UNWRAP_WETH"
