"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .signedauthorization import SignedAuthorization, SignedAuthorizationTypedDict
from compass_api_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UnsignedMulticallTransactionTypedDict(TypedDict):
    chain_id: str
    r"""The chain id of the transaction"""
    data: str
    r"""The data of the transaction"""
    from_: str
    r"""The sender of the transaction"""
    gas: Nullable[str]
    r"""The gas of the transaction"""
    to: str
    r"""The recipient of the transaction"""
    value: str
    r"""The value of the transaction"""
    nonce: str
    r"""The nonce of the address"""
    max_fee_per_gas: str
    r"""The max fee per gas of the transaction"""
    max_priority_fee_per_gas: str
    r"""The max priority fee per gas of the transaction"""
    authorization_list: NotRequired[List[SignedAuthorizationTypedDict]]
    r"""EIP-7702 authorization"""


class UnsignedMulticallTransaction(BaseModel):
    chain_id: Annotated[str, pydantic.Field(alias="chainId")]
    r"""The chain id of the transaction"""

    data: str
    r"""The data of the transaction"""

    from_: Annotated[str, pydantic.Field(alias="from")]
    r"""The sender of the transaction"""

    gas: Nullable[str]
    r"""The gas of the transaction"""

    to: str
    r"""The recipient of the transaction"""

    value: str
    r"""The value of the transaction"""

    nonce: str
    r"""The nonce of the address"""

    max_fee_per_gas: Annotated[str, pydantic.Field(alias="maxFeePerGas")]
    r"""The max fee per gas of the transaction"""

    max_priority_fee_per_gas: Annotated[
        str, pydantic.Field(alias="maxPriorityFeePerGas")
    ]
    r"""The max priority fee per gas of the transaction"""

    authorization_list: Annotated[
        Optional[List[SignedAuthorization]], pydantic.Field(alias="authorizationList")
    ] = None
    r"""EIP-7702 authorization"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["authorizationList"]
        nullable_fields = ["gas"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
